package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 税码feign客户端
 *
 * @author ultraman
 * @date 2024-07-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.TaxCode;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface TaxCodeFeignApi {

  /**
   * 通过id查询税码
   * @param  id
   * @return R
   */
  @GetMapping("/taxCode/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增税码
   * @param taxCode 税码
   * @return R
   */
  @PostMapping("/taxCode/add")
  public R save(@RequestBody TaxCode taxCode);

  /**
   * 修改税码
   * @param taxCode 税码
   * @return R
   */
  @PostMapping("/taxCode/update")
  public R updateById(@RequestBody TaxCode taxCode);

  /**
   * 通过id删除税码
   * @param  id
   * @return R
   */
  @DeleteMapping("/taxCode/del/{id}" )
  public R removeById(@PathVariable Long id);

}