package com.xforceplus.ultraman.app.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 发票登记表
 * </p>
 *
 * @author ultraman
 * @since 2022-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Invoice implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 前置单据号
   */
  @TableField("preNO")
  private String preNO;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 发票业务状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 发票影像
   */
  @TableField("invoiceUrl")
  private String invoiceUrl;

  /**
   * 开票日期
   */
  @TableField("paperDrawDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrawDate;

  /**
   * 寄送日期
   */
  @TableField("sendDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sendDate;

  /**
   * 收票日期
   */
  @TableField("receiptDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptDate;

  /**
   * 提交应付单日期
   */
  @TableField("submitDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime submitDate;

  /**
   * 应付过账日期
   */
  @TableField("postingDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime postingDate;

  /**
   * 支付日期
   */
  @TableField("paymentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;

  /**
   * 供应商名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 分公司名
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 快递单号
   */
  @TableField("expressNumber")
  private String expressNumber;

  /**
   * 版本号
   */
  private String version;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private String taxAmount;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private String amountWithoutTax;

  /**
   * 供应商编码
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 分公司id
   */
  @TableField("buyerID")
  private String buyerID;

  /**
   * 申请支付金额
   */
  @TableField("applyPayAmount")
  private String applyPayAmount;

  /**
   * 凭证号 
   */
  @TableField("voucherNo")
  private String voucherNo;

  /**
   * 凭证文本
   */
  @TableField("voucherText")
  private String voucherText;

  /**
   * 付款基准日
   */
  @TableField("payBaseDay")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payBaseDay;

  /**
   * 实际付款日
   */
  @TableField("actualPayDay")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualPayDay;

  /**
   * 认证日期
   */
  @TableField("authDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authDate;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * PO
   */
  @TableField("poNo")
  private String poNo;

  /**
   * 记账状态
   */
  @TableField("accountStatus")
  private String accountStatus;

  /**
   * 付款状态
   */
  @TableField("payStatus")
  private String payStatus;

  /**
   * 已支付金额
   */
  @TableField("paidAmount")
  private String paidAmount;

  /**
   * 发票付款金额
   */
  @TableField("invoicePayAmount")
  private String invoicePayAmount;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方地址电话
   */
  @TableField("sellerAddrTel")
  private String sellerAddrTel;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankNo")
  private String sellerBankNo;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方地址电话
   */
  @TableField("purchaserAddrTel")
  private String purchaserAddrTel;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankNo")
  private String purchaserBankNo;

  /**
   * 备注
   */
  private String remark;

  /**
   * 复核人姓名
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票人姓名
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 原发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 红字信息表编号
   */
  @TableField("redNotificationNo")
  private String redNotificationNo;

  /**
   * 认证所属期
   */
  @TableField("taxDeclarationPeriod")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxDeclarationPeriod;

  /**
   * 扫描时间
   */
  @TableField("scanTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scanTime;

  /**
   * 抵扣联影像ID
   */
  @TableField("scanDeductionImageUrl")
  private String scanDeductionImageUrl;

  /**
   * 发票联影像ID
   */
  @TableField("scanInvoiceImageUrl")
  private String scanInvoiceImageUrl;

  /**
   * 购方公司编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 发票状态
   */
  private String status;

  /**
   * 认证状态
   */
  @TableField("authStatus")
  private String authStatus;

  /**
   * 验真标志
   */
  @TableField("taxFlag")
  private String taxFlag;

  /**
   * 扫描状态
   */
  @TableField("scanStatus")
  private String scanStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("preNO", preNO);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceType", invoiceType);
      map.put("invoiceStatus", invoiceStatus);
      map.put("invoiceUrl", invoiceUrl);
      map.put("paperDrawDate", BocpGenUtils.toTimestamp(paperDrawDate));
      map.put("sendDate", BocpGenUtils.toTimestamp(sendDate));
      map.put("receiptDate", BocpGenUtils.toTimestamp(receiptDate));
      map.put("submitDate", BocpGenUtils.toTimestamp(submitDate));
      map.put("postingDate", BocpGenUtils.toTimestamp(postingDate));
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("expressNumber", expressNumber);
      map.put("version", version);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("sellerNo", sellerNo);
      map.put("buyerID", buyerID);
      map.put("applyPayAmount", applyPayAmount);
      map.put("voucherNo", voucherNo);
      map.put("voucherText", voucherText);
      map.put("payBaseDay", BocpGenUtils.toTimestamp(payBaseDay));
      map.put("actualPayDay", BocpGenUtils.toTimestamp(actualPayDay));
      map.put("authDate", BocpGenUtils.toTimestamp(authDate));
      map.put("paymentNo", paymentNo);
      map.put("poNo", poNo);
      map.put("accountStatus", accountStatus);
      map.put("payStatus", payStatus);
      map.put("paidAmount", paidAmount);
      map.put("invoicePayAmount", invoicePayAmount);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerBankNo", sellerBankNo);
      map.put("sellerBankName", sellerBankName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserAddrTel", purchaserAddrTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankNo", purchaserBankNo);
      map.put("remark", remark);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("redNotificationNo", redNotificationNo);
      map.put("taxDeclarationPeriod", BocpGenUtils.toTimestamp(taxDeclarationPeriod));
      map.put("scanTime", BocpGenUtils.toTimestamp(scanTime));
      map.put("scanDeductionImageUrl", scanDeductionImageUrl);
      map.put("scanInvoiceImageUrl", scanInvoiceImageUrl);
      map.put("purchaserNo", purchaserNo);
      map.put("status", status);
      map.put("authStatus", authStatus);
      map.put("taxFlag", taxFlag);
      map.put("scanStatus", scanStatus);
      return map;
  }

  public static Invoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Invoice entity = new Invoice();
    if(map.containsKey("preNO")) {
      Object obj = map.get("preNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSendDate(null);
      }
    }
    if(map.containsKey("receiptDate")) {
      Object obj = map.get("receiptDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptDate(null);
      }
    }
    if(map.containsKey("submitDate")) {
      Object obj = map.get("submitDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSubmitDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSubmitDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSubmitDate(null);
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPostingDate(null);
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expressNumber")) {
      Object obj = map.get("expressNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPayAmount")) {
      Object obj = map.get("applyPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherText")) {
      Object obj = map.get("voucherText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payBaseDay")) {
      Object obj = map.get("payBaseDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayBaseDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPayBaseDay((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPayBaseDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayBaseDay(null);
      }
    }
    if(map.containsKey("actualPayDay")) {
      Object obj = map.get("actualPayDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActualPayDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setActualPayDay((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setActualPayDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActualPayDay(null);
      }
    }
    if(map.containsKey("authDate")) {
      Object obj = map.get("authDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthDate(null);
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountStatus")) {
      Object obj = map.get("accountStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payStatus")) {
      Object obj = map.get("payStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaidAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicePayAmount")) {
      Object obj = map.get("invoicePayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicePayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNo")) {
      Object obj = map.get("purchaserBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDeclarationPeriod")) {
      Object obj = map.get("taxDeclarationPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxDeclarationPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxDeclarationPeriod(null);
      }
    }
    if(map.containsKey("scanTime")) {
      Object obj = map.get("scanTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScanTime(null);
      }
    }
    if(map.containsKey("scanDeductionImageUrl")) {
      Object obj = map.get("scanDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanInvoiceImageUrl")) {
      Object obj = map.get("scanInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxFlag")) {
      Object obj = map.get("taxFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanStatus")) {
      Object obj = map.get("scanStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
