package com.xforceplus.ultraman.app.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 采购单原始数据
 * </p>
 *
 * @author ultraman
 * @since 2022-04-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderInit implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 采购凭证
   */
  @TableField("poNumber")
  private String poNumber;

  /**
   * 项目
   */
  private String item;

  /**
   * 批准标识
   */
  @TableField("approvalLogo")
  private String approvalLogo;

  /**
   * 采购凭证类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 采购组
   */
  @TableField("purchaserGroup")
  private String purchaserGroup;

  /**
   * 凭证日期
   */
  @TableField("voucherDate")
  private String voucherDate;

  /**
   * 供应商/供应工厂
   */
  private String seller;

  /**
   * 物料
   */
  private String material;

  /**
   * 短文本
   */
  @TableField("shortText")
  private String shortText;

  /**
   * 物料组
   */
  @TableField("materialGroup")
  private String materialGroup;

  /**
   * 税码
   */
  @TableField("taxCode")
  private String taxCode;

  /**
   * 删除标识
   */
  @TableField("deleteStatus")
  private String deleteStatus;

  /**
   * 科目分配类别
   */
  @TableField("subjectAllocationType")
  private String subjectAllocationType;

  /**
   * 工厂
   */
  private String factory;

  /**
   * 采购订单数量
   */
  @TableField("purchaseOrderQuantity")
  private String purchaseOrderQuantity;

  /**
   * 订单单位
   */
  @TableField("orderUnit")
  private String orderUnit;

  /**
   * 净价
   */
  @TableField("netPrice")
  private String netPrice;

  /**
   * 货币
   */
  private String currency;

  /**
   * 价格单位
   */
  @TableField("priceUnit")
  private String priceUnit;

  /**
   * 仍要交货(数量)
   */
  @TableField("stillDeliveredQuantity")
  private String stillDeliveredQuantity;

  /**
   * 仍要交货(价值)
   */
  @TableField("stillDeliveredPrice")
  private String stillDeliveredPrice;

  /**
   * 仍要开票(数量)
   */
  @TableField("stillinvoicedQuantity")
  private String stillinvoicedQuantity;

  /**
   * 仍要开票(价值)
   */
  @TableField("stillinvoicedPrice")
  private String stillinvoicedPrice;

  /**
   * 发布状态
   */
  @TableField("postStatus")
  private String postStatus;

  /**
   * 创建日期
   */
  @TableField("createDate")
  private String createDate;

  /**
   * 创建者
   */
  @TableField("createUser")
  private String createUser;

  /**
   * 采购组织
   */
  @TableField("purchaserOrg")
  private String purchaserOrg;

  /**
   * 公司代码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 存储位置
   */
  @TableField("storageLocation")
  private String storageLocation;

  /**
   * 项目类别
   */
  @TableField("itemClassification")
  private String itemClassification;

  /**
   * 订单价格单位
   */
  @TableField("orderPriceUnit")
  private String orderPriceUnit;

  /**
   * 订单净值
   */
  @TableField("netValueOfTheOrder")
  private String netValueOfTheOrder;

  /**
   * 订单总价值
   */
  @TableField("totalValueOfOrder")
  private String totalValueOfOrder;

  /**
   * 交货已完成
   */
  @TableField("deliveryCompleted")
  private String deliveryCompleted;

  /**
   * 最后发票
   */
  @TableField("finalInvoice")
  private String finalInvoice;

  /**
   * 评估类型
   */
  @TableField("assessmentType")
  private String assessmentType;

  /**
   * SqNoAccAss
   */
  @TableField("sqNoAccAss")
  private String sqNoAccAss;

  /**
   * 分配(%)
   */
  private String distribution;

  /**
   * 总帐科目
   */
  @TableField("generalLedgerAccount")
  private String generalLedgerAccount;

  /**
   * 业务范围
   */
  @TableField("businessScope")
  private String businessScope;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 订单
   */
  private String order;

  /**
   * 利润中心
   */
  @TableField("profitCenter")
  private String profitCenter;

  /**
   * WBS要素
   */
  private String webs;

  /**
   * 网络
   */
  private String network;

  /**
   * 设备
   */
  private String equipment;

  /**
   * 序列号
   */
  @TableField("serialNumber")
  private String serialNumber;

  /**
   * 当前客户
   */
  @TableField("currentCustomer")
  private String currentCustomer;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("item", item);
      map.put("approvalLogo", approvalLogo);
      map.put("orderType", orderType);
      map.put("purchaserGroup", purchaserGroup);
      map.put("voucherDate", voucherDate);
      map.put("seller", seller);
      map.put("material", material);
      map.put("shortText", shortText);
      map.put("materialGroup", materialGroup);
      map.put("taxCode", taxCode);
      map.put("deleteStatus", deleteStatus);
      map.put("subjectAllocationType", subjectAllocationType);
      map.put("factory", factory);
      map.put("purchaseOrderQuantity", purchaseOrderQuantity);
      map.put("orderUnit", orderUnit);
      map.put("netPrice", netPrice);
      map.put("currency", currency);
      map.put("priceUnit", priceUnit);
      map.put("stillDeliveredQuantity", stillDeliveredQuantity);
      map.put("stillDeliveredPrice", stillDeliveredPrice);
      map.put("stillinvoicedQuantity", stillinvoicedQuantity);
      map.put("stillinvoicedPrice", stillinvoicedPrice);
      map.put("postStatus", postStatus);
      map.put("createDate", createDate);
      map.put("createUser", createUser);
      map.put("purchaserOrg", purchaserOrg);
      map.put("companyCode", companyCode);
      map.put("storageLocation", storageLocation);
      map.put("itemClassification", itemClassification);
      map.put("orderPriceUnit", orderPriceUnit);
      map.put("netValueOfTheOrder", netValueOfTheOrder);
      map.put("totalValueOfOrder", totalValueOfOrder);
      map.put("deliveryCompleted", deliveryCompleted);
      map.put("finalInvoice", finalInvoice);
      map.put("assessmentType", assessmentType);
      map.put("sqNoAccAss", sqNoAccAss);
      map.put("distribution", distribution);
      map.put("generalLedgerAccount", generalLedgerAccount);
      map.put("businessScope", businessScope);
      map.put("costCenter", costCenter);
      map.put("order", order);
      map.put("profitCenter", profitCenter);
      map.put("webs", webs);
      map.put("network", network);
      map.put("equipment", equipment);
      map.put("serialNumber", serialNumber);
      map.put("currentCustomer", currentCustomer);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static PurchaseOrderInit fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderInit entity = new PurchaseOrderInit();
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalLogo")) {
      Object obj = map.get("approvalLogo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalLogo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroup")) {
      Object obj = map.get("purchaserGroup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherDate")) {
      Object obj = map.get("voucherDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterial((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shortText")) {
      Object obj = map.get("shortText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShortText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialGroup")) {
      Object obj = map.get("materialGroup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCode")) {
      Object obj = map.get("taxCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deleteStatus")) {
      Object obj = map.get("deleteStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subjectAllocationType")) {
      Object obj = map.get("subjectAllocationType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubjectAllocationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFactory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrderQuantity")) {
      Object obj = map.get("purchaseOrderQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrderQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderUnit")) {
      Object obj = map.get("orderUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netPrice")) {
      Object obj = map.get("netPrice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceUnit")) {
      Object obj = map.get("priceUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stillDeliveredQuantity")) {
      Object obj = map.get("stillDeliveredQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStillDeliveredQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stillDeliveredPrice")) {
      Object obj = map.get("stillDeliveredPrice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStillDeliveredPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stillinvoicedQuantity")) {
      Object obj = map.get("stillinvoicedQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStillinvoicedQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stillinvoicedPrice")) {
      Object obj = map.get("stillinvoicedPrice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStillinvoicedPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserOrg")) {
      Object obj = map.get("purchaserOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storageLocation")) {
      Object obj = map.get("storageLocation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStorageLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemClassification")) {
      Object obj = map.get("itemClassification");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemClassification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderPriceUnit")) {
      Object obj = map.get("orderPriceUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderPriceUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netValueOfTheOrder")) {
      Object obj = map.get("netValueOfTheOrder");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetValueOfTheOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalValueOfOrder")) {
      Object obj = map.get("totalValueOfOrder");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalValueOfOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryCompleted")) {
      Object obj = map.get("deliveryCompleted");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeliveryCompleted((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("finalInvoice")) {
      Object obj = map.get("finalInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFinalInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assessmentType")) {
      Object obj = map.get("assessmentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssessmentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqNoAccAss")) {
      Object obj = map.get("sqNoAccAss");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSqNoAccAss((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distribution")) {
      Object obj = map.get("distribution");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDistribution((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessScope")) {
      Object obj = map.get("businessScope");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessScope((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order")) {
      Object obj = map.get("order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("webs")) {
      Object obj = map.get("webs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWebs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("network")) {
      Object obj = map.get("network");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetwork((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("equipment")) {
      Object obj = map.get("equipment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEquipment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNumber")) {
      Object obj = map.get("serialNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentCustomer")) {
      Object obj = map.get("currentCustomer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
