package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 税率税码枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-03-24
 */
public enum VatRate {

    I0("I0", "0.00"),
    IR("IR", "0.01"),
    I3("I3", "0.03"),
    IC("IC", "0.05"),
    I4("I4", "0.06"),
    IM("IM", "0.09"),
    IG("IG", "0.10"),
    I2("I2", "0.11"),
    IJ("IJ", "0.13"),
    ID("ID", "0.16"),
    I6("I6", "017");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VatRate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VatRate fromCode(String code){
        switch(code) {
            case "I0":
                return I0;
            case "IR":
                return IR;
            case "I3":
                return I3;
            case "IC":
                return IC;
            case "I4":
                return I4;
            case "IM":
                return IM;
            case "IG":
                return IG;
            case "I2":
                return I2;
            case "IJ":
                return IJ;
            case "ID":
                return ID;
            case "I6":
                return I6;
            default:
                return null;
        }
    }
}
