package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-03-28
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    SE("se", "增值税电子专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    CT("ct", "增值税普通发票（通行费）"),
    JU("ju", "增值税普通发票（卷票）"),
    V("v", "机动车统一销售发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "se":
                return SE;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ct":
                return CT;
            case "ju":
                return JU;
            case "v":
                return V;
            default:
                return null;
        }
    }
}
