package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 费用类型
 * </p>
 *
 * @author ultraman
 * @since 2022-06-09
 */
public enum ExpenseType {

    SSF("SSF", "诉讼费"),
    BYJ("BYJ", "备用金"),
    B01("B01", "维保金"),
    B02("B02", "履约保证金"),
    B03("B03", "质量保证金");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExpenseType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExpenseType fromCode(String code){
        switch(code) {
            case "SSF":
                return SSF;
            case "BYJ":
                return BYJ;
            case "B01":
                return B01;
            case "B02":
                return B02;
            case "B03":
                return B03;
            default:
                return null;
        }
    }
}
