package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * rpa任务阶段
 * </p>
 *
 * @author ultraman
 * @since 2022-06-09
 */
public enum RpaTaskStage {

    _0("0", "无回执"),
    _1_1("1-1", "po数据回执"),
    _1_2("1-2", "wbs数据回执"),
    _2_1("2-1", "预付款提交"),
    _2_2("2-2", "预付款付款"),
    _3_1("3-1", "应付款提交"),
    _3_2("3-2", "应付款付款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RpaTaskStage(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RpaTaskStage fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1-1":
                return _1_1;
            case "1-2":
                return _1_2;
            case "2-1":
                return _2_1;
            case "2-2":
                return _2_2;
            case "3-1":
                return _3_1;
            case "3-2":
                return _3_2;
            default:
                return null;
        }
    }
}
