package com.xforceplus.ultraman.app.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.jctke.entity.Imprest;

/**
 * <p>
 * 无po单预付单
 * </p>
 *
 * @author ultraman
 * @since 2022-06-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class NoPoImprest extends Imprest {


  /**
   * 预付子类型
   */
  private String imprestSubType;

  /**
   *  合同ID
   */
  private String contractId;

  /**
   * 合同类型
   */
  private String contractType;

  /**
   * 合同名称
   */
  private String contractName;

  /**
   * 合同签订日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractSignDate;

  /**
   * 合同开始日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractStartDate;

  /**
   * 合同结束日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractEndDate;

  /**
   * 户名
   */
  private String supplierName;

  /**
   * 开户行
   */
  private String supplierBank;

  /**
   * 本次实付金额
   */
  private BigDecimal payAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("imprest_sub_type", imprestSubType);
      map.put("contract_id", contractId);
      map.put("contract_type", contractType);
      map.put("contract_name", contractName);
      map.put("contract_sign_date", BocpGenUtils.toTimestamp(contractSignDate));
      map.put("contract_start_date", BocpGenUtils.toTimestamp(contractStartDate));
      map.put("contract_end_date", BocpGenUtils.toTimestamp(contractEndDate));
      map.put("supplier_name", supplierName);
      map.put("supplier_bank", supplierBank);
      map.put("pay_amount", payAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static NoPoImprest fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    NoPoImprest entity = new NoPoImprest();
    if(map.containsKey("apply_id")) {
      Object obj = map.get("apply_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_order_type")) {
      Object obj = map.get("payment_order_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pre_business_type")) {
      Object obj = map.get("pre_business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_id")) {
      Object obj = map.get("pay_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer")) {
      Object obj = map.get("payer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_bank_type")) {
      Object obj = map.get("pay_bank_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayBankType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_remark")) {
      Object obj = map.get("pay_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_sap_text")) {
      Object obj = map.get("entry_sap_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntrySapText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attachment_url")) {
      Object obj = map.get("attachment_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachmentUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imprest_voucher_no")) {
      Object obj = map.get("imprest_voucher_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImprestVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("download_user_id")) {
      Object obj = map.get("download_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("download_user_name")) {
      Object obj = map.get("download_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("download_status")) {
      Object obj = map.get("download_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_last_date")) {
      Object obj = map.get("pay_last_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayLastDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayLastDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPayLastDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setPayLastDate(null);
      }
    }
    if(map.containsKey("current_approver")) {
      Object obj = map.get("current_approver");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentApprover((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approval_record")) {
      Object obj = map.get("approval_record");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRecord((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("other_remark")) {
      Object obj = map.get("other_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOtherRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imprest_type")) {
      Object obj = map.get("imprest_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImprestType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payee_bank_account")) {
      Object obj = map.get("payee_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayeeBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imprest_sub_type")) {
      Object obj = map.get("imprest_sub_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImprestSubType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_id")) {
      Object obj = map.get("contract_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_type")) {
      Object obj = map.get("contract_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_name")) {
      Object obj = map.get("contract_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_sign_date")) {
      Object obj = map.get("contract_sign_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractSignDate(null);
      }
    }
    if(map.containsKey("contract_start_date")) {
      Object obj = map.get("contract_start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractStartDate(null);
      }
    }
    if(map.containsKey("contract_end_date")) {
      Object obj = map.get("contract_end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractEndDate(null);
      }
    }
    if(map.containsKey("supplier_name")) {
      Object obj = map.get("supplier_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplier_bank")) {
      Object obj = map.get("supplier_bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
