package com.xforceplus.ultraman.app.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.jctke.entity.Imprest;

/**
 * <p>
 *  po预付单
 * </p>
 *
 * @author ultraman
 * @since 2022-04-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PoImprest extends Imprest {


  /**
   *  总金额
   */
  private String totalAmount;

  /**
   * 已支付金额
   */
  private String paidAmount;

  /**
   * 申请实付金额
   */
  private String applyPayAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("total_amount", totalAmount);
      map.put("paid_amount", paidAmount);
      map.put("apply_pay_amount", applyPayAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static PoImprest fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PoImprest entity = new PoImprest();
    if(map.containsKey("apply_id")) {
      Object obj = map.get("apply_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_order_type")) {
      Object obj = map.get("payment_order_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pre_business_type")) {
      Object obj = map.get("pre_business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_id")) {
      Object obj = map.get("pay_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer")) {
      Object obj = map.get("payer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_bank_type")) {
      Object obj = map.get("pay_bank_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayBankType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_remark")) {
      Object obj = map.get("pay_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_sap_text")) {
      Object obj = map.get("entry_sap_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntrySapText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attachment_url")) {
      Object obj = map.get("attachment_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachmentUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imprest_voucher_no")) {
      Object obj = map.get("imprest_voucher_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImprestVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("download_user_id")) {
      Object obj = map.get("download_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("download_user_name")) {
      Object obj = map.get("download_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("download_status")) {
      Object obj = map.get("download_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_last_date")) {
      Object obj = map.get("pay_last_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayLastDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayLastDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPayLastDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setPayLastDate(null);
      }
    }
    if(map.containsKey("current_approver")) {
      Object obj = map.get("current_approver");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentApprover((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approval_record")) {
      Object obj = map.get("approval_record");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRecord((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("other_remark")) {
      Object obj = map.get("other_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOtherRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imprest_type")) {
      Object obj = map.get("imprest_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImprestType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payee_bank_account")) {
      Object obj = map.get("payee_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayeeBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paid_amount")) {
      Object obj = map.get("paid_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaidAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_pay_amount")) {
      Object obj = map.get("apply_pay_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
