package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 系统错误码
 * </p>
 *
 * @author ultraman
 * @since 2022-06-27
 */
public enum ErrorCode {

    E001("E001", "不同付款对象的业务单不允许合并"),
    E002("E002", "不同采购组的业务单不允许合并"),
    E003("E003", "提交金额异常，请检查"),
    E004("E004", "注意，该单中的发票尚未被完全签核"),
    E005("E005", "不同业务类型的采购订单不允许被同时勾选。"),
    E006("E006", "不同订单类型的采购订单不允许被同时勾选。"),
    E007("E007", "所勾选的采购订单金额已经都被创建了开票通知。"),
    E008("E008", "请填写正确的金额。"),
    E009("E009", "已有相同的收货单被创建了开票通知。"),
    E010("E010", "BI校验未通过，请重新填写"),
    E011("E011", "注意，该单中的发票尚未被完全签核"),
    E012("E012", "付款对象ID对应的个人信息不存"),
    E013("E013", "所勾选的开票通知单已经生成业务单"),
    E014("E014", "成功"),
    E015("E015", "失败"),
    E016("E016", "只允许单条操作"),
    E017("E017", "参数不能为空"),
    E018("E018", "当前申请人不允许为空"),
    E019("E019", "业务类型不允许为空"),
    E024("E024", "发票主数据异常"),
    E025("E025", "发票关联的业务单不存在"),
    E026("E026", "未找到符合条件的开票通知单"),
    E020("E020", "付款类型不允许为空"),
    E021("E021", "预付类型子类不允许为空"),
    E022("E022", "当前状态不允许为空"),
    E023("E023", "付款对象不允许为空"),
    E027("E027", "不同业务单号不允许提交"),
    E028("E028", "不同业务类型不允许提交"),
    E029("E029", "不同供应商不允许提交"),
    E030("E030", "不同采购组不允许提交"),
    E031("E031", "本次数量不允许大于收货数量"),
    E032("E032", "本次金额不允许大于收货金额"),
    E033("E033", "利润中心不允许为空"),
    E034("E034", "当前角色不允许为空"),
    E035("E035", "生成结算单失败"),
    E036("E036", "所勾选的存在已生成结算单的开票通知单"),
    E037("E037", "所勾选的存在已配单的开票通知单"),
    E038("E038", "所勾选的存在非系统非税类开票通知单"),
    E039("E039", "业务单号不允许为空"),
    E040("E040", "供应商不允许为空"),
    E041("E041", "勾选了不存在的开票通知单"),
    E042("E042", "勾选了不存在的发票"),
    E043("E043", "创建代理费应付单时只能从单个PO关联的开票通知单中勾选"),
    E044("E044", "合并配单的单据需要一起勾选"),
    E045("E045", "采购单已关联开票通知单"),
    E046("E046", "采购单已生成逆向预付单"),
    E047("E047", "采购单存在状态为已支付以外的预付单"),
    E048("E048", "采购单状态必须为正常状态"),
    E049("E049", "凭证号的行数需要与金额的行数一致，凭证号不可重复");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErrorCode fromCode(String code){
        switch(code) {
            case "E001":
                return E001;
            case "E002":
                return E002;
            case "E003":
                return E003;
            case "E004":
                return E004;
            case "E005":
                return E005;
            case "E006":
                return E006;
            case "E007":
                return E007;
            case "E008":
                return E008;
            case "E009":
                return E009;
            case "E010":
                return E010;
            case "E011":
                return E011;
            case "E012":
                return E012;
            case "E013":
                return E013;
            case "E014":
                return E014;
            case "E015":
                return E015;
            case "E016":
                return E016;
            case "E017":
                return E017;
            case "E018":
                return E018;
            case "E019":
                return E019;
            case "E024":
                return E024;
            case "E025":
                return E025;
            case "E026":
                return E026;
            case "E020":
                return E020;
            case "E021":
                return E021;
            case "E022":
                return E022;
            case "E023":
                return E023;
            case "E027":
                return E027;
            case "E028":
                return E028;
            case "E029":
                return E029;
            case "E030":
                return E030;
            case "E031":
                return E031;
            case "E032":
                return E032;
            case "E033":
                return E033;
            case "E034":
                return E034;
            case "E035":
                return E035;
            case "E036":
                return E036;
            case "E037":
                return E037;
            case "E038":
                return E038;
            case "E039":
                return E039;
            case "E040":
                return E040;
            case "E041":
                return E041;
            case "E042":
                return E042;
            case "E043":
                return E043;
            case "E044":
                return E044;
            case "E045":
                return E045;
            case "E046":
                return E046;
            case "E047":
                return E047;
            case "E048":
                return E048;
            case "E049":
                return E049;
            default:
                return null;
        }
    }
}
