package com.xforceplus.ultraman.app.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-06-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AdvanceChargeInterface implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * 付款类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 付款单创建日期
   */
  @TableField("paymentTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentTime;

  /**
   * 付款单财月
   */
  @TableField("paymentMonth")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentMonth;

  /**
   * 利润中心
   */
  @TableField("profitCenter")
  private String profitCenter;

  /**
   * PO号
   */
  @TableField("poNo")
  private String poNo;

  /**
   * 供应商ID
   */
  @TableField("supplierId")
  private String supplierId;

  /**
   * 总账标识
   */
  @TableField("ledgerType")
  private String ledgerType;

  /**
   * 汇率
   */
  @TableField("exchangeRate")
  private String exchangeRate;

  /**
   * 公司代码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 税码
   */
  @TableField("taxCode")
  private String taxCode;

  /**
   * 文本
   */
  private String text;

  /**
   * 预付款金额
   */
  @TableField("advanceChargeAmount")
  private String advanceChargeAmount;

  /**
   * 付款到期日
   */
  @TableField("paymentDueDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDueDate;

  /**
   * 入库时间
   */
  @TableField("warehousingTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime warehousingTime;

  /**
   * 推送RPA任务号
   */
  @TableField("rpaTaskId")
  private String rpaTaskId;

  /**
   * 预付款请求号
   */
  @TableField("prePaymentNo")
  private String prePaymentNo;

  /**
   * 预付款凭证号 
   */
  @TableField("prepaymentPaymentVoucher")
  private String prepaymentPaymentVoucher;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 付款对象id
   */
  @TableField("paymentObjectId")
  private String paymentObjectId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("paymentNo", paymentNo);
      map.put("paymentType", paymentType);
      map.put("paymentTime", BocpGenUtils.toTimestamp(paymentTime));
      map.put("paymentMonth", BocpGenUtils.toTimestamp(paymentMonth));
      map.put("profitCenter", profitCenter);
      map.put("poNo", poNo);
      map.put("supplierId", supplierId);
      map.put("ledgerType", ledgerType);
      map.put("exchangeRate", exchangeRate);
      map.put("companyCode", companyCode);
      map.put("taxCode", taxCode);
      map.put("text", text);
      map.put("advanceChargeAmount", advanceChargeAmount);
      map.put("paymentDueDate", BocpGenUtils.toTimestamp(paymentDueDate));
      map.put("warehousingTime", BocpGenUtils.toTimestamp(warehousingTime));
      map.put("rpaTaskId", rpaTaskId);
      map.put("prePaymentNo", prePaymentNo);
      map.put("prepaymentPaymentVoucher", prepaymentPaymentVoucher);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("paymentObjectId", paymentObjectId);
      return map;
  }

  public static AdvanceChargeInterface fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AdvanceChargeInterface entity = new AdvanceChargeInterface();
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTime")) {
      Object obj = map.get("paymentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentTime(null);
      }
    }
    if(map.containsKey("paymentMonth")) {
      Object obj = map.get("paymentMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentMonth(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentMonth((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentMonth(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentMonth(null);
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierId")) {
      Object obj = map.get("supplierId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ledgerType")) {
      Object obj = map.get("ledgerType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLedgerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exchangeRate")) {
      Object obj = map.get("exchangeRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExchangeRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCode")) {
      Object obj = map.get("taxCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("advanceChargeAmount")) {
      Object obj = map.get("advanceChargeAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAdvanceChargeAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDueDate")) {
      Object obj = map.get("paymentDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDueDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDueDate(null);
      }
    }
    if(map.containsKey("warehousingTime")) {
      Object obj = map.get("warehousingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarehousingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setWarehousingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setWarehousingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setWarehousingTime(null);
      }
    }
    if(map.containsKey("rpaTaskId")) {
      Object obj = map.get("rpaTaskId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRpaTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentNo")) {
      Object obj = map.get("prePaymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrePaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentPaymentVoucher")) {
      Object obj = map.get("prepaymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObjectId")) {
      Object obj = map.get("paymentObjectId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentObjectId((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
