package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 任务类型
 * </p>
 *
 * @author ultraman
 * @since 2022-07-04
 */
public enum TaskType {

    _1("1", "紧急PO拉取"),
    _2("2", "F47"),
    _3("3", "MIRO"),
    _4("4", "F44"),
    _5("5", "F51"),
    _6("6", "FBRA"),
    _7("7", "FBL1N");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
