package com.xforceplus.ultraman.app.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PayInvoNoBillRelation implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请id
   */
  @TableField("applyId")
  private String applyId;

  /**
   * 开票通知单号
   */
  @TableField("invoiceNoticeNO")
  private String invoiceNoticeNO;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 付款单id
   */
  @TableField("payMentId")
  private Long payMentId;

  /**
   * 开票通知单id
   */
  @TableField("invoiceNoticeBillId")
  private Long invoiceNoticeBillId;

  /**
   * 已应付金额
   */
  @TableField("paidAmount")
  private BigDecimal paidAmount;

  /**
   * 开票通知单明细id
   */
  @TableField("invoiceNoticeBillTeamId")
  private Long invoiceNoticeBillTeamId;

  /**
   * 已应付数量
   */
  @TableField("paidQuantity")
  private BigDecimal paidQuantity;

  /**
   * 采购单号
   */
  @TableField("preNo")
  private String preNo;

  /**
   * 开票通知单明细行号
   */
  @TableField("itemNO")
  private String itemNO;

  /**
   * 付款状态
   */
  @TableField("paymentStatus")
  private String paymentStatus;

  /**
   * 付款状态公式
   */
  @TableField("paymentStatusExp")
  private String paymentStatusExp;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyId", applyId);
      map.put("invoiceNoticeNO", invoiceNoticeNO);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("payMentId", payMentId);
      map.put("invoiceNoticeBillId", invoiceNoticeBillId);
      map.put("paidAmount", paidAmount);
      map.put("invoiceNoticeBillTeamId", invoiceNoticeBillTeamId);
      map.put("paidQuantity", paidQuantity);
      map.put("preNo", preNo);
      map.put("itemNO", itemNO);
      map.put("paymentStatus", paymentStatus);
      map.put("paymentStatusExp", paymentStatusExp);
      return map;
  }

  public static PayInvoNoBillRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PayInvoNoBillRelation entity = new PayInvoNoBillRelation();
    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNO")) {
      Object obj = map.get("invoiceNoticeNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payMentId")) {
      Object obj = map.get("payMentId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayMentId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPayMentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPayMentId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillId")) {
      Object obj = map.get("invoiceNoticeBillId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceNoticeBillId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceNoticeBillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceNoticeBillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillTeamId")) {
      Object obj = map.get("invoiceNoticeBillTeamId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceNoticeBillTeamId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceNoticeBillTeamId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceNoticeBillTeamId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paidQuantity")) {
      Object obj = map.get("paidQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaidQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaidQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaidQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaidQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaidQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("preNo")) {
      Object obj = map.get("preNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNO")) {
      Object obj = map.get("itemNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatusExp")) {
      Object obj = map.get("paymentStatusExp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatusExp((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
