package com.xforceplus.ultraman.app.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 采购订单主信息
 * </p>
 *
 * @author ultraman
 * @since 2022-04-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrder implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("poNumber")
  private String poNumber;

  /**
   * 供应商号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 供应商名
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 付款方式
   */
  @TableField("paymentTerm")
  private String paymentTerm;

  /**
   * 分公司名
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 开票地址
   */
  @TableField("licenseAddress")
  private String licenseAddress;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 订单不含税总金额
   */
  private String amount;

  /**
   * 已付款金额
   */
  @TableField("payedAmount")
  private String payedAmount;

  /**
   * 已开票金额
   */
  @TableField("invoicedAmount")
  private String invoicedAmount;

  /**
   * 待开票金额
   */
  @TableField("waitForInvoiceAmount")
  private String waitForInvoiceAmount;

  /**
   * 已收货金额
   */
  @TableField("deliveriedAmount")
  private String deliveriedAmount;

  /**
   * 预付金额
   */
  @TableField("prepayAmount")
  private String prepayAmount;

  /**
   * 未付金额
   */
  @TableField("unpayedAmount")
  private String unpayedAmount;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 分公司ID
   */
  @TableField("buyerID")
  private String buyerID;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 版本号
   */
  @TableField("poVersion")
  private String poVersion;

  /**
   * 失败原因
   */
  @TableField("failureReason")
  private String failureReason;

  /**
   * 采购组
   */
  @TableField("purchasingTeam")
  private String purchasingTeam;

  /**
   * 采购组织
   */
  @TableField("purchasingOrg")
  private String purchasingOrg;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 已预付待核销金额
   */
  @TableField("prepaidAmount")
  private String prepaidAmount;

  /**
   * 分公司发票ID
   */
  @TableField("buyerInvoiceID")
  private String buyerInvoiceID;

  /**
   * 分公司发票抬头
   */
  @TableField("buyerInvoiceTitle")
  private String buyerInvoiceTitle;

  /**
   * 订单含税总金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 是否是协同供应商
   */
  @TableField("isCoord")
  private Boolean isCoord;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 供应商税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 购方编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 结算单号
   */
  @TableField("businessOrderNo")
  private String businessOrderNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("paymentTerm", paymentTerm);
      map.put("buyerName", buyerName);
      map.put("licenseAddress", licenseAddress);
      map.put("businessType", businessType);
      map.put("amount", amount);
      map.put("payedAmount", payedAmount);
      map.put("invoicedAmount", invoicedAmount);
      map.put("waitForInvoiceAmount", waitForInvoiceAmount);
      map.put("deliveriedAmount", deliveriedAmount);
      map.put("prepayAmount", prepayAmount);
      map.put("unpayedAmount", unpayedAmount);
      map.put("orderType", orderType);
      map.put("buyerID", buyerID);
      map.put("orderStatus", orderStatus);
      map.put("poVersion", poVersion);
      map.put("failureReason", failureReason);
      map.put("purchasingTeam", purchasingTeam);
      map.put("purchasingOrg", purchasingOrg);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("prepaidAmount", prepaidAmount);
      map.put("buyerInvoiceID", buyerInvoiceID);
      map.put("buyerInvoiceTitle", buyerInvoiceTitle);
      map.put("amountWithTax", amountWithTax);
      map.put("isCoord", isCoord);
      map.put("invoiceType", invoiceType);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("purchaserNo", purchaserNo);
      map.put("businessOrderNo", businessOrderNo);
      return map;
  }

  public static PurchaseOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrder entity = new PurchaseOrder();
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTerm")) {
      Object obj = map.get("paymentTerm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentTerm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("licenseAddress")) {
      Object obj = map.get("licenseAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLicenseAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWaitForInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeliveriedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnpayedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poVersion")) {
      Object obj = map.get("poVersion");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFailureReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaidAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isCoord")) {
      Object obj = map.get("isCoord");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsCoord((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsCoord(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessOrderNo")) {
      Object obj = map.get("businessOrderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessOrderNo((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
