package com.xforceplus.ultraman.app.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderItem implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 采购单号
   */
  @TableField("poNumber")
  private String poNumber;

  /**
   * 采购单行号
   */
  private Long item;

  /**
   * 物料号
   */
  @TableField("materialServices")
  private String materialServices;

  /**
   * WBS
   */
  private String wbs;

  /**
   * 物料名称
   */
  @TableField("materialServicesName")
  private String materialServicesName;

  /**
   * 币种
   */
  private String currency;

  /**
   * 梯号
   */
  @TableField("ladderNo")
  private String ladderNo;

  /**
   * 合同号
   */
  @TableField("contractID")
  private String contractID;

  /**
   * 梯台状态Id
   */
  @TableField("ladderStatusID")
  private String ladderStatusID;

  /**
   * 梯台状态
   */
  @TableField("ladderStatus")
  private String ladderStatus;

  /**
   * 税码
   */
  @TableField("vatCode")
  private String vatCode;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 物料组
   */
  @TableField("materialServicesTeam")
  private String materialServicesTeam;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 利润中心
   */
  @TableField("profitsCenter")
  private String profitsCenter;

  /**
   * 总账科目
   */
  @TableField("generalLedgerAccount")
  private String generalLedgerAccount;

  /**
   * View id
   */
  @TableField("viewId")
  private String viewId;

  /**
   * 审批状态
   */
  @TableField("releaseStatus")
  private String releaseStatus;

  /**
   * PM节点
   */
  @TableField("pmNode")
  private String pmNode;

  /**
   * 单位
   */
  @TableField("quantityUnit")
  private String quantityUnit;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 缺失信息描述
   */
  @TableField("absentMsg")
  private String absentMsg;

  /**
   * 删除标记
   */
  @TableField("isDelete")
  private Boolean isDelete;

  /**
   * 单价
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 发布状态
   */
  @TableField("postStatus")
  private String postStatus;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 已收货数量
   */
  @TableField("receivedCount")
  private String receivedCount;

  /**
   * 已收货含税金额
   */
  @TableField("receivedAmount")
  private String receivedAmount;

  /**
   * 已生成开票通知单数量
   */
  @TableField("invoiceNoticeBillQuantity")
  private String invoiceNoticeBillQuantity;

  /**
   * 已生成开票通知单金额
   */
  @TableField("invoiceNoticeBillAmount")
  private String invoiceNoticeBillAmount;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private String amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private String taxAmount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("item", item);
      map.put("materialServices", materialServices);
      map.put("wbs", wbs);
      map.put("materialServicesName", materialServicesName);
      map.put("currency", currency);
      map.put("ladderNo", ladderNo);
      map.put("contractID", contractID);
      map.put("ladderStatusID", ladderStatusID);
      map.put("ladderStatus", ladderStatus);
      map.put("vatCode", vatCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("materialServicesTeam", materialServicesTeam);
      map.put("costCenter", costCenter);
      map.put("profitsCenter", profitsCenter);
      map.put("generalLedgerAccount", generalLedgerAccount);
      map.put("viewId", viewId);
      map.put("releaseStatus", releaseStatus);
      map.put("pmNode", pmNode);
      map.put("quantityUnit", quantityUnit);
      map.put("quantity", quantity);
      map.put("absentMsg", absentMsg);
      map.put("isDelete", isDelete);
      map.put("unitPrice", unitPrice);
      map.put("amountWithTax", amountWithTax);
      map.put("orderStatus", orderStatus);
      map.put("postStatus", postStatus);
      map.put("taxRate", taxRate);
      map.put("receivedCount", receivedCount);
      map.put("receivedAmount", receivedAmount);
      map.put("invoiceNoticeBillQuantity", invoiceNoticeBillQuantity);
      map.put("invoiceNoticeBillAmount", invoiceNoticeBillAmount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      return map;
  }

  public static PurchaseOrderItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderItem entity = new PurchaseOrderItem();
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusID")) {
      Object obj = map.get("ladderStatusID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatusID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatus")) {
      Object obj = map.get("ladderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setViewId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("releaseStatus")) {
      Object obj = map.get("releaseStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReleaseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPmNode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDelete((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivedCount")) {
      Object obj = map.get("receivedCount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceivedCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivedAmount")) {
      Object obj = map.get("receivedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceivedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillQuantity")) {
      Object obj = map.get("invoiceNoticeBillQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeBillQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillAmount")) {
      Object obj = map.get("invoiceNoticeBillAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeBillAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
