package com.xforceplus.ultraman.app.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 外键为预付单id，用于聚合已核销金额
 * </p>
 *
 * @author ultraman
 * @since 2022-08-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PrepaymentWriteRelation implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 应付款申请id
   */
  @TableField("applyId")
  private String applyId;

  /**
   * 预付款申请id
   */
  @TableField("impApplyId")
  private String impApplyId;

  /**
   * 预付款核销金额
   */
  @TableField("prepaymentWriteAmount")
  private BigDecimal prepaymentWriteAmount;

  /**
   * 预付款核销凭证
   */
  @TableField("prepaymentWriteVoucher")
  private String prepaymentWriteVoucher;

  /**
   * 预付款凭证
   */
  @TableField("prepaymentPaymentVoucher")
  private String prepaymentPaymentVoucher;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 付款类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 付款状态
   */
  @TableField("paymentStatus")
  private String paymentStatus;

  /**
   * 业务类型
   */
  private String xxx;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyId", applyId);
      map.put("impApplyId", impApplyId);
      map.put("prepaymentWriteAmount", prepaymentWriteAmount);
      map.put("prepaymentWriteVoucher", prepaymentWriteVoucher);
      map.put("prepaymentPaymentVoucher", prepaymentPaymentVoucher);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("paymentType", paymentType);
      map.put("paymentStatus", paymentStatus);
      map.put("xxx", xxx);
      return map;
  }

  public static PrepaymentWriteRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PrepaymentWriteRelation entity = new PrepaymentWriteRelation();
    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("impApplyId")) {
      Object obj = map.get("impApplyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImpApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentWriteAmount")) {
      Object obj = map.get("prepaymentWriteAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepaymentWriteAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepaymentWriteAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepaymentWriteAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPrepaymentWriteAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepaymentWriteAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentWriteVoucher")) {
      Object obj = map.get("prepaymentWriteVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentWriteVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentPaymentVoucher")) {
      Object obj = map.get("prepaymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxx")) {
      Object obj = map.get("xxx");
      if(obj != null) {
        if(obj instanceof String){
          entity.setXxx((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
