package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 邮件发送场景
 * </p>
 *
 * @author ultraman
 * @since 2022-08-08
 */
public enum EmailSendScene {

    REJECT("reject", "应付单预付单驳回通知"),
    F47_ERROR("F47Error", "F-47执行报错通知"),
    M_I_R_O_ERROR("MIROError", "MIRO执行报错通知"),
    BACK("back", "发票登记表总部财务退回通知");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EmailSendScene(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EmailSendScene fromCode(String code){
        switch(code) {
            case "reject":
                return REJECT;
            case "F47Error":
                return F47_ERROR;
            case "MIROError":
                return M_I_R_O_ERROR;
            case "back":
                return BACK;
            default:
                return null;
        }
    }
}
