package com.xforceplus.ultraman.app.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 发票主信息#含增税和非税发票
 * </p>
 *
 * @author ultraman
 * @since 2022-12-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Invoice implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 结算单号
   */
  @TableField("preNO")
  private String preNO;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 发票业务状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 发票影像
   */
  @TableField("invoiceUrl")
  private String invoiceUrl;

  /**
   * 开票日期
   */
  @TableField("paperDrawDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrawDate;

  /**
   * 寄送日期
   */
  @TableField("sendDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sendDate;

  /**
   * 收票日期
   */
  @TableField("receiptDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptDate;

  /**
   * 提交应付单日期
   */
  @TableField("submitDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime submitDate;

  /**
   * 应付过账日期
   */
  @TableField("postingDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime postingDate;

  /**
   * 支付日期
   */
  @TableField("paymentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;

  /**
   * 配单供应商名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 执行分公司
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 快递单号
   */
  @TableField("expressNumber")
  private String expressNumber;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 供应商编码
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 分公司id
   */
  @TableField("buyerID")
  private String buyerID;

  /**
   * 申请支付金额
   */
  @TableField("applyPayAmount")
  private BigDecimal applyPayAmount;

  /**
   * 凭证号 
   */
  @TableField("voucherNo")
  private String voucherNo;

  /**
   * 凭证文本
   */
  @TableField("voucherText")
  private String voucherText;

  /**
   * 付款基准日
   */
  @TableField("payBaseDay")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payBaseDay;

  /**
   * 实际付款日
   */
  @TableField("actualPayDay")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualPayDay;

  /**
   * 认证日期
   */
  @TableField("authDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authDate;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * PO
   */
  @TableField("poNo")
  private String poNo;

  /**
   * 记账状态
   */
  @TableField("accountStatus")
  private String accountStatus;

  /**
   * 付款状态
   */
  @TableField("payStatus")
  private String payStatus;

  /**
   * 已支付金额
   */
  @TableField("paidAmount")
  private BigDecimal paidAmount;

  /**
   * 发票付款金额
   */
  @TableField("invoicePayAmount")
  private BigDecimal invoicePayAmount;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方地址电话
   */
  @TableField("sellerAddrTel")
  private String sellerAddrTel;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankNo")
  private String sellerBankNo;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方地址电话
   */
  @TableField("purchaserAddrTel")
  private String purchaserAddrTel;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankNo")
  private String purchaserBankNo;

  /**
   * 备注
   */
  private String remark;

  /**
   * 复核人姓名
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票人姓名
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 原发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 红字信息表编号
   */
  @TableField("redNotificationNo")
  private String redNotificationNo;

  /**
   * 认证所属期
   */
  @TableField("taxDeclarationPeriod")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxDeclarationPeriod;

  /**
   * 扫描时间
   */
  @TableField("scanTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scanTime;

  /**
   * 抵扣联影像ID
   */
  @TableField("scanDeductionImageUrl")
  private String scanDeductionImageUrl;

  /**
   * 发票联影像ID
   */
  @TableField("scanInvoiceImageUrl")
  private String scanInvoiceImageUrl;

  /**
   * 购方公司编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 发票状态
   */
  private String status;

  /**
   * 认证状态
   */
  @TableField("authStatus")
  private String authStatus;

  /**
   * 验真标志
   */
  @TableField("taxFlag")
  private String taxFlag;

  /**
   * 扫描状态
   */
  @TableField("scanStatus")
  private String scanStatus;

  /**
   * 初始来源
   */
  private String source;

  /**
   * 开票通知单号
   */
  @TableField("invoiceNoticeNos")
  private String invoiceNoticeNos;

  /**
   * 发票id
   */
  @TableField("invoiceId")
  private String invoiceId;

  /**
   * 采购组
   */
  @TableField("purchasingTeam")
  private String purchasingTeam;

  /**
   * 寄送次数
   */
  @TableField("sendCount")
  private Long sendCount;

  /**
   * 退回次数	
   */
  @TableField("backCount")
  private Long backCount;

  /**
   * 是否推荐
   */
  @TableField("recommendationFlag")
  private Boolean recommendationFlag;

  /**
   * 已配单金额
   */
  @TableField("matchedAmount")
  private String matchedAmount;

  /**
   * 记账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountDate;

  /**
   * 关联次数
   */
  @TableField("relationCount")
  private Long relationCount;

  /**
   * 最近来源
   */
  @TableField("lastSource")
  private String lastSource;

  /**
   * 源文件类型(0-无源文件 1-PDF 2-OFD)
   */
  @TableField("originFile")
  private String originFile;

  /**
   * 源文件地址
   */
  @TableField("originFileUrl")
  private String originFileUrl;

  /**
   * 退回原因
   */
  @TableField("returnReason")
  private String returnReason;

  /**
   * 配单金额
   */
  @TableField("availableAmount")
  private BigDecimal availableAmount;

  /**
   * 序列号
   */
  @TableField("serialNo")
  private String serialNo;

  /**
   * 是否代开
   */
  @TableField("isReplace")
  private String isReplace;

  /**
   * 代开销方名称
   */
  @TableField("replaceSellerName")
  private String replaceSellerName;

  /**
   * 代开销方税号
   */
  @TableField("replaceSellerTaxNo")
  private String replaceSellerTaxNo;

  /**
   * 源销方名称
   */
  @TableField("originSellerName")
  private String originSellerName;

  /**
   * 源销方税号
   */
  @TableField("originSellerTaxNo")
  private String originSellerTaxNo;

  /**
   * 初始配单不含税金额
   */
  @TableField("availableAmountWithoutTax")
  private BigDecimal availableAmountWithoutTax;

  /**
   * 影像id
   */
  @TableField("imageId")
  private String imageId;

  /**
   * 协同类型
   */
  @TableField("coordinationType")
  private String coordinationType;

  /**
   * 已配单不含税金额
   */
  @TableField("matchedAmountWithoutTax")
  private String matchedAmountWithoutTax;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("preNO", preNO);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceType", invoiceType);
      map.put("invoiceStatus", invoiceStatus);
      map.put("invoiceUrl", invoiceUrl);
      map.put("paperDrawDate", BocpGenUtils.toTimestamp(paperDrawDate));
      map.put("sendDate", BocpGenUtils.toTimestamp(sendDate));
      map.put("receiptDate", BocpGenUtils.toTimestamp(receiptDate));
      map.put("submitDate", BocpGenUtils.toTimestamp(submitDate));
      map.put("postingDate", BocpGenUtils.toTimestamp(postingDate));
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("expressNumber", expressNumber);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("sellerNo", sellerNo);
      map.put("buyerID", buyerID);
      map.put("applyPayAmount", applyPayAmount);
      map.put("voucherNo", voucherNo);
      map.put("voucherText", voucherText);
      map.put("payBaseDay", BocpGenUtils.toTimestamp(payBaseDay));
      map.put("actualPayDay", BocpGenUtils.toTimestamp(actualPayDay));
      map.put("authDate", BocpGenUtils.toTimestamp(authDate));
      map.put("paymentNo", paymentNo);
      map.put("poNo", poNo);
      map.put("accountStatus", accountStatus);
      map.put("payStatus", payStatus);
      map.put("paidAmount", paidAmount);
      map.put("invoicePayAmount", invoicePayAmount);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerBankNo", sellerBankNo);
      map.put("sellerBankName", sellerBankName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserAddrTel", purchaserAddrTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankNo", purchaserBankNo);
      map.put("remark", remark);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("redNotificationNo", redNotificationNo);
      map.put("taxDeclarationPeriod", BocpGenUtils.toTimestamp(taxDeclarationPeriod));
      map.put("scanTime", BocpGenUtils.toTimestamp(scanTime));
      map.put("scanDeductionImageUrl", scanDeductionImageUrl);
      map.put("scanInvoiceImageUrl", scanInvoiceImageUrl);
      map.put("purchaserNo", purchaserNo);
      map.put("status", status);
      map.put("authStatus", authStatus);
      map.put("taxFlag", taxFlag);
      map.put("scanStatus", scanStatus);
      map.put("source", source);
      map.put("invoiceNoticeNos", invoiceNoticeNos);
      map.put("invoiceId", invoiceId);
      map.put("purchasingTeam", purchasingTeam);
      map.put("sendCount", sendCount);
      map.put("backCount", backCount);
      map.put("recommendationFlag", recommendationFlag);
      map.put("matchedAmount", matchedAmount);
      map.put("account_date", BocpGenUtils.toTimestamp(accountDate));
      map.put("relationCount", relationCount);
      map.put("lastSource", lastSource);
      map.put("originFile", originFile);
      map.put("originFileUrl", originFileUrl);
      map.put("returnReason", returnReason);
      map.put("availableAmount", availableAmount);
      map.put("serialNo", serialNo);
      map.put("isReplace", isReplace);
      map.put("replaceSellerName", replaceSellerName);
      map.put("replaceSellerTaxNo", replaceSellerTaxNo);
      map.put("originSellerName", originSellerName);
      map.put("originSellerTaxNo", originSellerTaxNo);
      map.put("availableAmountWithoutTax", availableAmountWithoutTax);
      map.put("imageId", imageId);
      map.put("coordinationType", coordinationType);
      map.put("matchedAmountWithoutTax", matchedAmountWithoutTax);
      return map;
  }

  public static Invoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Invoice entity = new Invoice();
    if(map.containsKey("preNO")) {
      Object obj = map.get("preNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSendDate(null);
      }
    }
    if(map.containsKey("receiptDate")) {
      Object obj = map.get("receiptDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReceiptDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptDate(null);
      }
    }
    if(map.containsKey("submitDate")) {
      Object obj = map.get("submitDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSubmitDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSubmitDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSubmitDate(null);
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPostingDate(null);
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expressNumber")) {
      Object obj = map.get("expressNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPayAmount")) {
      Object obj = map.get("applyPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setApplyPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setApplyPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setApplyPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setApplyPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherText")) {
      Object obj = map.get("voucherText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payBaseDay")) {
      Object obj = map.get("payBaseDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayBaseDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayBaseDay((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPayBaseDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayBaseDay(null);
      }
    }
    if(map.containsKey("actualPayDay")) {
      Object obj = map.get("actualPayDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActualPayDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setActualPayDay((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setActualPayDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActualPayDay(null);
      }
    }
    if(map.containsKey("authDate")) {
      Object obj = map.get("authDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthDate(null);
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountStatus")) {
      Object obj = map.get("accountStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payStatus")) {
      Object obj = map.get("payStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePayAmount")) {
      Object obj = map.get("invoicePayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoicePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNo")) {
      Object obj = map.get("purchaserBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDeclarationPeriod")) {
      Object obj = map.get("taxDeclarationPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTaxDeclarationPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxDeclarationPeriod(null);
      }
    }
    if(map.containsKey("scanTime")) {
      Object obj = map.get("scanTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScanTime(null);
      }
    }
    if(map.containsKey("scanDeductionImageUrl")) {
      Object obj = map.get("scanDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanInvoiceImageUrl")) {
      Object obj = map.get("scanInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxFlag")) {
      Object obj = map.get("taxFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanStatus")) {
      Object obj = map.get("scanStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNos")) {
      Object obj = map.get("invoiceNoticeNos");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendCount")) {
      Object obj = map.get("sendCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setSendCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSendCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("backCount")) {
      Object obj = map.get("backCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBackCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setBackCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBackCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recommendationFlag")) {
      Object obj = map.get("recommendationFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setRecommendationFlag((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setRecommendationFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("matchedAmount")) {
      Object obj = map.get("matchedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_date")) {
      Object obj = map.get("account_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAccountDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountDate(null);
      }
    }
    if(map.containsKey("relationCount")) {
      Object obj = map.get("relationCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRelationCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setRelationCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRelationCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lastSource")) {
      Object obj = map.get("lastSource");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originFile")) {
      Object obj = map.get("originFile");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originFileUrl")) {
      Object obj = map.get("originFileUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnReason")) {
      Object obj = map.get("returnReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("availableAmount")) {
      Object obj = map.get("availableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAvailableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAvailableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAvailableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAvailableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAvailableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isReplace")) {
      Object obj = map.get("isReplace");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsReplace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replaceSellerName")) {
      Object obj = map.get("replaceSellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReplaceSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replaceSellerTaxNo")) {
      Object obj = map.get("replaceSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReplaceSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originSellerName")) {
      Object obj = map.get("originSellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originSellerTaxNo")) {
      Object obj = map.get("originSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("availableAmountWithoutTax")) {
      Object obj = map.get("availableAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAvailableAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAvailableAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAvailableAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAvailableAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAvailableAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("imageId")) {
      Object obj = map.get("imageId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coordinationType")) {
      Object obj = map.get("coordinationType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCoordinationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchedAmountWithoutTax")) {
      Object obj = map.get("matchedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchedAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("preNO")) {
      Object obj = map.get("preNO");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreNO((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSendDate(null);
      }
    }
    if(map.containsKey("receiptDate")) {
      Object obj = map.get("receiptDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceiptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReceiptDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setReceiptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReceiptDate(null);
      }
    }
    if(map.containsKey("submitDate")) {
      Object obj = map.get("submitDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSubmitDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSubmitDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setSubmitDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSubmitDate(null);
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPostingDate(null);
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaymentDate(null);
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expressNumber")) {
      Object obj = map.get("expressNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpressNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyPayAmount")) {
      Object obj = map.get("applyPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setApplyPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setApplyPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setApplyPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setApplyPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setApplyPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("voucherText")) {
      Object obj = map.get("voucherText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVoucherText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payBaseDay")) {
      Object obj = map.get("payBaseDay");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayBaseDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayBaseDay((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setPayBaseDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayBaseDay(null);
      }
    }
    if(map.containsKey("actualPayDay")) {
      Object obj = map.get("actualPayDay");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActualPayDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setActualPayDay((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setActualPayDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setActualPayDay(null);
      }
    }
    if(map.containsKey("authDate")) {
      Object obj = map.get("authDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setAuthDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthDate(null);
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountStatus")) {
      Object obj = map.get("accountStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payStatus")) {
      Object obj = map.get("payStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoicePayAmount")) {
      Object obj = map.get("invoicePayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoicePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoicePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoicePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setInvoicePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoicePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankNo")) {
      Object obj = map.get("purchaserBankNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxDeclarationPeriod")) {
      Object obj = map.get("taxDeclarationPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTaxDeclarationPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setTaxDeclarationPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTaxDeclarationPeriod(null);
      }
    }
    if(map.containsKey("scanTime")) {
      Object obj = map.get("scanTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setScanTime(null);
      }
    }
    if(map.containsKey("scanDeductionImageUrl")) {
      Object obj = map.get("scanDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScanDeductionImageUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scanInvoiceImageUrl")) {
      Object obj = map.get("scanInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScanInvoiceImageUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxFlag")) {
      Object obj = map.get("taxFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scanStatus")) {
      Object obj = map.get("scanStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScanStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNoticeNos")) {
      Object obj = map.get("invoiceNoticeNos");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNoticeNos((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchasingTeam((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sendCount")) {
      Object obj = map.get("sendCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSendCount((Long)obj);
        } else if(obj instanceof String) {
          this.setSendCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSendCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("backCount")) {
      Object obj = map.get("backCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBackCount((Long)obj);
        } else if(obj instanceof String) {
          this.setBackCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBackCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("recommendationFlag")) {
      Object obj = map.get("recommendationFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setRecommendationFlag((Boolean)obj);
        } else if(obj instanceof String) {
          this.setRecommendationFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("matchedAmount")) {
      Object obj = map.get("matchedAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchedAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_date")) {
      Object obj = map.get("account_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAccountDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAccountDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setAccountDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAccountDate(null);
      }
    }
    if(map.containsKey("relationCount")) {
      Object obj = map.get("relationCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRelationCount((Long)obj);
        } else if(obj instanceof String) {
          this.setRelationCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRelationCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("lastSource")) {
      Object obj = map.get("lastSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originFile")) {
      Object obj = map.get("originFile");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginFile((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originFileUrl")) {
      Object obj = map.get("originFileUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginFileUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnReason")) {
      Object obj = map.get("returnReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("availableAmount")) {
      Object obj = map.get("availableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAvailableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAvailableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAvailableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAvailableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAvailableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isReplace")) {
      Object obj = map.get("isReplace");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsReplace((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("replaceSellerName")) {
      Object obj = map.get("replaceSellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReplaceSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("replaceSellerTaxNo")) {
      Object obj = map.get("replaceSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReplaceSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originSellerName")) {
      Object obj = map.get("originSellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originSellerTaxNo")) {
      Object obj = map.get("originSellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("availableAmountWithoutTax")) {
      Object obj = map.get("availableAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAvailableAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAvailableAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAvailableAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAvailableAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAvailableAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("imageId")) {
      Object obj = map.get("imageId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImageId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("coordinationType")) {
      Object obj = map.get("coordinationType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCoordinationType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matchedAmountWithoutTax")) {
      Object obj = map.get("matchedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchedAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
  }
}
