package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-01-17
 */
public enum InvoiceOperation {

    BACK("back", "退回"),
    SEND("send", "寄送"),
    SIGN("sign", "签收"),
    ACCEPT_RECOMMENDATION("acceptRecommendation", "接受推荐"),
    MANUAL_MATCH_ORDER("manualMatchOrder", "手工配单"),
    CANCEL_MATCH_ORDER("cancelMatchOrder", "取消配单"),
    ACCOUNT("account", "记账"),
    PAY("pay", "支付"),
    RELATION_BLUE_INVOICE("relationBlueInvoice", "关联蓝票"),
    DELETE("delete", "删除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceOperation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOperation fromCode(String code){
        switch(code) {
            case "back":
                return BACK;
            case "send":
                return SEND;
            case "sign":
                return SIGN;
            case "acceptRecommendation":
                return ACCEPT_RECOMMENDATION;
            case "manualMatchOrder":
                return MANUAL_MATCH_ORDER;
            case "cancelMatchOrder":
                return CANCEL_MATCH_ORDER;
            case "account":
                return ACCOUNT;
            case "pay":
                return PAY;
            case "relationBlueInvoice":
                return RELATION_BLUE_INVOICE;
            case "delete":
                return DELETE;
            default:
                return null;
        }
    }
}
