package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办对象
 * </p>
 *
 * @author ultraman
 * @since 2023-01-29
 */
public enum ProduceObj {

    PURCHASE_ORDER("PURCHASE_ORDER", "采购单待办"),
    RECEIVE_ORDER("RECEIVE_ORDER", "收货单待办"),
    NOTICE_ORDER("NOTICE_ORDER", "开票通知单待办");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProduceObj(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceObj fromCode(String code){
        switch(code) {
            case "PURCHASE_ORDER":
                return PURCHASE_ORDER;
            case "RECEIVE_ORDER":
                return RECEIVE_ORDER;
            case "NOTICE_ORDER":
                return NOTICE_ORDER;
            default:
                return null;
        }
    }
}
