package com.xforceplus.ultraman.app.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-08-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WeiAmountApproval implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 费用类型
   */
  @TableField("expenseType")
  private String expenseType;

  /**
   * 占比
   */
  private BigDecimal proportion;

  /**
   * 保证金金额
   */
  @TableField("marginAmount")
  private BigDecimal marginAmount;

  /**
   * 到期天数
   */
  @TableField("expireDays")
  private Long expireDays;

  /**
   * 角色编码
   */
  @TableField("roleType")
  private String roleType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 角色序号
   */
  @TableField("roleSerialNumber")
  private Long roleSerialNumber;

  /**
   * 角色英文描述
   */
  @TableField("roleEnglishDescription")
  private String roleEnglishDescription;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("expenseType", expenseType);
      map.put("proportion", proportion);
      map.put("marginAmount", marginAmount);
      map.put("expireDays", expireDays);
      map.put("roleType", roleType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("roleSerialNumber", roleSerialNumber);
      map.put("roleEnglishDescription", roleEnglishDescription);
      return map;
  }

  public static WeiAmountApproval fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    WeiAmountApproval entity = new WeiAmountApproval();
    if(map.containsKey("expenseType")) {
      Object obj = map.get("expenseType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpenseType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("proportion")) {
      Object obj = map.get("proportion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProportion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProportion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProportion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setProportion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProportion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("marginAmount")) {
      Object obj = map.get("marginAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMarginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMarginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMarginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMarginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMarginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expireDays")) {
      Object obj = map.get("expireDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpireDays((Long)obj);
        } else if(obj instanceof String) {
          entity.setExpireDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setExpireDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("roleType")) {
      Object obj = map.get("roleType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRoleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("roleSerialNumber")) {
      Object obj = map.get("roleSerialNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRoleSerialNumber((Long)obj);
        } else if(obj instanceof String) {
          entity.setRoleSerialNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRoleSerialNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("roleEnglishDescription")) {
      Object obj = map.get("roleEnglishDescription");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRoleEnglishDescription((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
