package com.xforceplus.ultraman.app.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 采购单主信息
 * </p>
 *
 * @author ultraman
 * @since 2023-04-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrder implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 采购单号
   */
  @TableField("poNumber")
  private String poNumber;

  /**
   * 销方编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 执行分公司
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 执行分公司Id
   */
  @TableField("buyerID")
  private String buyerID;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 失败原因
   */
  @TableField("failureReason")
  private String failureReason;

  /**
   * 采购组
   */
  @TableField("purchasingTeam")
  private String purchasingTeam;

  /**
   * 采购组织
   */
  @TableField("purchasingOrg")
  private String purchasingOrg;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票分公司Id
   */
  @TableField("buyerInvoiceID")
  private String buyerInvoiceID;

  /**
   * 发票分公司
   */
  @TableField("buyerInvoiceTitle")
  private String buyerInvoiceTitle;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 购方编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankNo")
  private String sellerBankNo;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方联系电话
   */
  @TableField("sellerTelephone")
  private String sellerTelephone;

  /**
   * 购方银行账号
   */
  @TableField("purchaseBankNo")
  private String purchaseBankNo;

  /**
   * 购方银行名称
   */
  @TableField("purchaseBankName")
  private String purchaseBankName;

  /**
   * 购方地址
   */
  @TableField("purchaseAddress")
  private String purchaseAddress;

  /**
   * 购方联系电话
   */
  @TableField("purchaseTelephone")
  private String purchaseTelephone;

  /**
   * 虚拟采购单类型
   */
  @TableField("virtualPoType")
  private String virtualPoType;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 已收货含税金额
   */
  @TableField("deliveriedAmount")
  private String deliveriedAmount;

  /**
   * 待开票金额
   */
  @TableField("waitForInvoiceAmount")
  private String waitForInvoiceAmount;

  /**
   * 未付金额
   */
  @TableField("unpayedAmount")
  private String unpayedAmount;

  /**
   * 缺失描述
   */
  @TableField("absentMsg")
  private String absentMsg;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 已开票金额
   */
  @TableField("invoicedAmount")
  private String invoicedAmount;

  /**
   * 逆向付款单号
   */
  @TableField("negativePaymentNo")
  private String negativePaymentNo;

  /**
   * 换票类型
   */
  @TableField("alterInvoiceIndicator")
  private String alterInvoiceIndicator;

  /**
   * 原采购单号
   */
  @TableField("previousPONo")
  private String previousPONo;

  /**
   * 新采购单号
   */
  @TableField("nextPONo")
  private String nextPONo;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private String amountWithoutTax;

  /**
   * 已生成开票通知单金额
   */
  @TableField("invoiceNoticeBillAmount")
  private String invoiceNoticeBillAmount;

  /**
   * 已应付金额
   */
  @TableField("payedAmount")
  private String payedAmount;

  /**
   * 已预付金额
   */
  @TableField("prepayAmount")
  private String prepayAmount;

  /**
   * 已支付金额
   */
  @TableField("allPaidAmount")
  private String allPaidAmount;

  /**
   * 已核销金额
   */
  @TableField("writeOffAmount")
  private String writeOffAmount;

  /**
   * 已预付待核销金额
   */
  @TableField("prepaidAmount")
  private String prepaidAmount;

  /**
   * 上一个订单状态
   */
  @TableField("preOrderStatus")
  private String preOrderStatus;

  /**
   * 测试金额
   */
  @TableField("testAmount")
  private BigDecimal testAmount;

  /**
   * 已开票不含税金额
   */
  @TableField("invoicedAmountWithoutTax")
  private String invoicedAmountWithoutTax;

  /**
   * 待开票不含税金额
   */
  @TableField("waitForInvoiceAmountWithoutTax")
  private String waitForInvoiceAmountWithoutTax;

  /**
   * 初始是否协同
   */
  @TableField("isSynergy")
  private Boolean isSynergy;

  /**
   * 邮件处理状态
   */
  @TableField("eamilProcessStatus")
  private String eamilProcessStatus;

  /**
   * 邮件处理状态
   */
  @TableField("eamilProcessStatusRaw")
  private String eamilProcessStatusRaw;

  /**
   * 项目定义
   */
  @TableField("projectDefinition")
  private String projectDefinition;

  /**
   * 梯号
   */
  @TableField("ladderNo")
  private String ladderNo;

  /**
   * PM节点
   */
  @TableField("pmNode")
  private String pmNode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("businessType", businessType);
      map.put("orderType", orderType);
      map.put("buyerID", buyerID);
      map.put("orderStatus", orderStatus);
      map.put("failureReason", failureReason);
      map.put("purchasingTeam", purchasingTeam);
      map.put("purchasingOrg", purchasingOrg);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("buyerInvoiceID", buyerInvoiceID);
      map.put("buyerInvoiceTitle", buyerInvoiceTitle);
      map.put("invoiceType", invoiceType);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("purchaserNo", purchaserNo);
      map.put("sellerBankNo", sellerBankNo);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTelephone", sellerTelephone);
      map.put("purchaseBankNo", purchaseBankNo);
      map.put("purchaseBankName", purchaseBankName);
      map.put("purchaseAddress", purchaseAddress);
      map.put("purchaseTelephone", purchaseTelephone);
      map.put("virtualPoType", virtualPoType);
      map.put("projectName", projectName);
      map.put("deliveriedAmount", deliveriedAmount);
      map.put("waitForInvoiceAmount", waitForInvoiceAmount);
      map.put("unpayedAmount", unpayedAmount);
      map.put("absentMsg", absentMsg);
      map.put("amountWithTax", amountWithTax);
      map.put("invoicedAmount", invoicedAmount);
      map.put("negativePaymentNo", negativePaymentNo);
      map.put("alterInvoiceIndicator", alterInvoiceIndicator);
      map.put("previousPONo", previousPONo);
      map.put("nextPONo", nextPONo);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("invoiceNoticeBillAmount", invoiceNoticeBillAmount);
      map.put("payedAmount", payedAmount);
      map.put("prepayAmount", prepayAmount);
      map.put("allPaidAmount", allPaidAmount);
      map.put("writeOffAmount", writeOffAmount);
      map.put("prepaidAmount", prepaidAmount);
      map.put("preOrderStatus", preOrderStatus);
      map.put("testAmount", testAmount);
      map.put("invoicedAmountWithoutTax", invoicedAmountWithoutTax);
      map.put("waitForInvoiceAmountWithoutTax", waitForInvoiceAmountWithoutTax);
      map.put("isSynergy", isSynergy);
      map.put("eamilProcessStatus", eamilProcessStatus);
      map.put("eamilProcessStatusRaw", eamilProcessStatusRaw);
      map.put("projectDefinition", projectDefinition);
      map.put("ladderNo", ladderNo);
      map.put("pmNode", pmNode);
      return map;
  }

  public static PurchaseOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrder entity = new PurchaseOrder();
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFailureReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtualPoType")) {
      Object obj = map.get("virtualPoType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVirtualPoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeliveriedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWaitForInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnpayedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("negativePaymentNo")) {
      Object obj = map.get("negativePaymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNegativePaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alterInvoiceIndicator")) {
      Object obj = map.get("alterInvoiceIndicator");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAlterInvoiceIndicator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousPONo")) {
      Object obj = map.get("previousPONo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreviousPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nextPONo")) {
      Object obj = map.get("nextPONo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNextPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillAmount")) {
      Object obj = map.get("invoiceNoticeBillAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeBillAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allPaidAmount")) {
      Object obj = map.get("allPaidAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAllPaidAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("writeOffAmount")) {
      Object obj = map.get("writeOffAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWriteOffAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaidAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preOrderStatus")) {
      Object obj = map.get("preOrderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("testAmount")) {
      Object obj = map.get("testAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTestAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTestAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTestAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTestAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTestAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmountWithoutTax")) {
      Object obj = map.get("invoicedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicedAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitForInvoiceAmountWithoutTax")) {
      Object obj = map.get("waitForInvoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWaitForInvoiceAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isSynergy")) {
      Object obj = map.get("isSynergy");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsSynergy((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsSynergy(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("eamilProcessStatus")) {
      Object obj = map.get("eamilProcessStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEamilProcessStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("eamilProcessStatusRaw")) {
      Object obj = map.get("eamilProcessStatusRaw");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEamilProcessStatusRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectDefinition")) {
      Object obj = map.get("projectDefinition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectDefinition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPmNode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFailureReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchasingTeam((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchasingOrg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerInvoiceID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerInvoiceTitle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTelephone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBankNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseTelephone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("virtualPoType")) {
      Object obj = map.get("virtualPoType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVirtualPoType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveriedAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWaitForInvoiceAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnpayedAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAbsentMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicedAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("negativePaymentNo")) {
      Object obj = map.get("negativePaymentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNegativePaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alterInvoiceIndicator")) {
      Object obj = map.get("alterInvoiceIndicator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAlterInvoiceIndicator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("previousPONo")) {
      Object obj = map.get("previousPONo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreviousPONo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nextPONo")) {
      Object obj = map.get("nextPONo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNextPONo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNoticeBillAmount")) {
      Object obj = map.get("invoiceNoticeBillAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNoticeBillAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayedAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrepayAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("allPaidAmount")) {
      Object obj = map.get("allPaidAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllPaidAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("writeOffAmount")) {
      Object obj = map.get("writeOffAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWriteOffAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrepaidAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("preOrderStatus")) {
      Object obj = map.get("preOrderStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("testAmount")) {
      Object obj = map.get("testAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTestAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTestAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTestAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTestAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTestAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoicedAmountWithoutTax")) {
      Object obj = map.get("invoicedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicedAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waitForInvoiceAmountWithoutTax")) {
      Object obj = map.get("waitForInvoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWaitForInvoiceAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isSynergy")) {
      Object obj = map.get("isSynergy");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsSynergy((Boolean)obj);
        } else if(obj instanceof String) {
          this.setIsSynergy(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("eamilProcessStatus")) {
      Object obj = map.get("eamilProcessStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEamilProcessStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("eamilProcessStatusRaw")) {
      Object obj = map.get("eamilProcessStatusRaw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEamilProcessStatusRaw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectDefinition")) {
      Object obj = map.get("projectDefinition");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectDefinition((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLadderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPmNode((String)obj);
        }
      } else {
      }
    }
  }
}
