package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 协同类型
 * </p>
 *
 * @author ultraman
 * @since 2023-04-27
 */
public enum InvoiceNoticeType {

    _0("0", "非协同"),
    _2("2", "协同");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceNoticeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceNoticeType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
