package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * role_type
 * </p>
 *
 * @author ultraman
 * @since 2024-02-22
 */
public enum RoleType {

    A0001("A0001", "申请人"),
    A002("A002", "分公司部门经理"),
    A003("A003", "分公司总经理（BGM）"),
    A004("A004", "区域总经理（RGM）"),
    A005("A005", "首席财务官（CFO）"),
    A006("A006", "总部财务（预付）"),
    A007("A007", "总部财务（应付）"),
    A100("A100", "供应商"),
    A008("A008", "BUAP/tkEAG/tkAG"),
    A009("A009", "区域财务（RFC）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RoleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RoleType fromCode(String code){
        switch(code) {
            case "A0001":
                return A0001;
            case "A002":
                return A002;
            case "A003":
                return A003;
            case "A004":
                return A004;
            case "A005":
                return A005;
            case "A006":
                return A006;
            case "A007":
                return A007;
            case "A100":
                return A100;
            case "A008":
                return A008;
            case "A009":
                return A009;
            default:
                return null;
        }
    }
}
