package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auto_goods_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum AutoGoodsType {

    RECEIVE_GOODS("receiveGoods", "收货"),
    CANCEL("cancel", "取消收货");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AutoGoodsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoGoodsType fromCode(String code){
        switch(code) {
            case "receiveGoods":
                return RECEIVE_GOODS;
            case "cancel":
                return CANCEL;
            default:
                return null;
        }
    }
}
