package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * code_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum CodeType {

    L_1("L_1", "虚拟采购单号"),
    I_1("I_1", "归档序列号");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CodeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CodeType fromCode(String code){
        switch(code) {
            case "L_1":
                return L_1;
            case "I_1":
                return I_1;
            default:
                return null;
        }
    }
}
