package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * contract_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum ContractType {

    _0("0", "默认"),
    _1("1", "配件销售与维修合同"),
    _2("2", "改造合同"),
    _3("3", "维保合同"),
    _4("4", "设备合同"),
    _5("5", "安装合同"),
    _6("6", "总合同（设备+安装）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ContractType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
