package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * email_send_scene
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum EmailSendScene {

    REJECT("reject", "即时通知申请人付款单驳回"),
    F47_ERROR("F47Error", "即时通知财务F-47处理失败"),
    M_I_R_O_ERROR("MIROError", "即时通知财务MIRO处理失败"),
    BACK("back", "即时通知分公司发票退回"),
    ISSUE_AN_INVOICE_INFORM("issueAnInvoiceInform", "即时通知供应商开票（本地物料）"),
    INVOICE_NOTICE_BILL("invoiceNoticeBill", "即时通知供应商开票"),
    PAYMENT_SUBMIT_NOTIFY("paymentSubmitNotify", "即时通知分公司审批应付单（安装&本地物料）"),
    F47__RESPONSE__ERROR("F47_Response_Error", "定时通知财务F-47失败清单"),
    F51__RESPONSE__ERROR("F51_Response_Error", "定时通知财务F-51失败清单"),
    F44__RESPONSE__ERROR("F44_Response_Error", "定时通知财务F-44失败清单"),
    M_I_R_O__RESPONSE__ERROR("MIRO_Response_Error", "定时通知财务MIRO失败清单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EmailSendScene(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EmailSendScene fromCode(String code){
        switch(code) {
            case "reject":
                return REJECT;
            case "F47Error":
                return F47_ERROR;
            case "MIROError":
                return M_I_R_O_ERROR;
            case "back":
                return BACK;
            case "issueAnInvoiceInform":
                return ISSUE_AN_INVOICE_INFORM;
            case "invoiceNoticeBill":
                return INVOICE_NOTICE_BILL;
            case "paymentSubmitNotify":
                return PAYMENT_SUBMIT_NOTIFY;
            case "F47_Response_Error":
                return F47__RESPONSE__ERROR;
            case "F51_Response_Error":
                return F51__RESPONSE__ERROR;
            case "F44_Response_Error":
                return F44__RESPONSE__ERROR;
            case "MIRO_Response_Error":
                return M_I_R_O__RESPONSE__ERROR;
            default:
                return null;
        }
    }
}
