package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * withdraw_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum WithdrawType {

    WITHDRAW_EXPRESS_AND_IMAGE("withdrawExpressAndImage", "退回影像和物流"),
    WITHDRAW_IMAGE("withdrawImage", "仅退回影像");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    WithdrawType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WithdrawType fromCode(String code){
        switch(code) {
            case "withdrawExpressAndImage":
                return WITHDRAW_EXPRESS_AND_IMAGE;
            case "withdrawImage":
                return WITHDRAW_IMAGE;
            default:
                return null;
        }
    }
}
