package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * purchase_order_operation
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum PurchaseOrderOperation {

    MODIFY("modify", "运维修改");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PurchaseOrderOperation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurchaseOrderOperation fromCode(String code){
        switch(code) {
            case "modify":
                return MODIFY;
            default:
                return null;
        }
    }
}
