package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_register_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum InvoiceRegisterStatus {

    _0("0", "作废"),
    _1("1", "正常"),
    _3("3", "红冲"),
    _8("8", "失控"),
    _4("4", "部分红冲"),
    _7("7", "异常"),
    _9("9", "删除"),
    _5("5", "全额红冲");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceRegisterStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceRegisterStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "3":
                return _3;
            case "8":
                return _8;
            case "4":
                return _4;
            case "7":
                return _7;
            case "9":
                return _9;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
