package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    SE("se", "增值税电子专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    CT("ct", "增值税电子普通发票（通行费)"),
    OTHER("other", "其他发票"),
    PAYMENT("payment", "海关缴款书"),
    GM("gm", "通用手工发票"),
    LER("ler", "诉讼费收据"),
    CSF("csf", "罚没财务专用发票"),
    TP("tp", "税收缴款书"),
    TPC("tpc", "税收完税证明"),
    FR("fr", "非税收入票据"),
    SPCIV("spciv", "海关进口增值税缴款书"),
    SPCIT("spcit", "海关进口关税缴款书"),
    X("x", "形式发票"),
    QC("qc", "数电增值税电子普通发票"),
    QS("qs", "数电增值税电子专用发票"),
    CZ("cz", "数电增值税纸质普通发票"),
    SZ("sz", "数电增值税纸质专用发票"),
    QUOTA("quota", "定额发票"),
    CB("cb", "增值税电子普通发票（区块链）"),
    CD("cd", "通用电子发票"),
    CJ("cj", "增值税普通发票（卷票）"),
    J("j", "机动车发票"),
    JU("ju", "增值税普通发票（卷票）"),
    V("v", "机动车统一销售发票"),
    T("t", "火车票"),
    TAXI("taxi", "出租车票"),
    VS("vs", "二手车发票"),
    IM("im", "通用机打发票"),
    TOLL("toll", "过路费发票"),
    P("p", "飞机票"),
    BUS("bus", "客运公交票"),
    CDF("cdf", "海关货物报关单"),
    FC("fc", "财政票据"),
    FCE("fce", "通用财政票据（电子）"),
    MOE("moe", "医疗门诊收费票据（电子）"),
    MHE("mhe", "医疗住院收费票据（电子）"),
    FJ("fj", "附件");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "se":
                return SE;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ct":
                return CT;
            case "other":
                return OTHER;
            case "payment":
                return PAYMENT;
            case "gm":
                return GM;
            case "ler":
                return LER;
            case "csf":
                return CSF;
            case "tp":
                return TP;
            case "tpc":
                return TPC;
            case "fr":
                return FR;
            case "spciv":
                return SPCIV;
            case "spcit":
                return SPCIT;
            case "x":
                return X;
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            case "quota":
                return QUOTA;
            case "cb":
                return CB;
            case "cd":
                return CD;
            case "cj":
                return CJ;
            case "j":
                return J;
            case "ju":
                return JU;
            case "v":
                return V;
            case "t":
                return T;
            case "taxi":
                return TAXI;
            case "vs":
                return VS;
            case "im":
                return IM;
            case "toll":
                return TOLL;
            case "p":
                return P;
            case "bus":
                return BUS;
            case "cdf":
                return CDF;
            case "fc":
                return FC;
            case "fce":
                return FCE;
            case "moe":
                return MOE;
            case "mhe":
                return MHE;
            case "fj":
                return FJ;
            default:
                return null;
        }
    }
}
