package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_operation
 * </p>
 *
 * @author ultraman
 * @since 2024-08-22
 */
public enum InvoiceOperation {

    BACK("back", "退回"),
    SEND("send", "寄送"),
    SIGN("sign", "签核"),
    ACCEPT_RECOMMENDATION("acceptRecommendation", "接受推荐"),
    MANUAL_MATCH_ORDER("manualMatchOrder", "手工配单"),
    CANCEL_MATCH_ORDER("cancelMatchOrder", "手工取消配单"),
    ACCOUNT("account", "记账"),
    PAY("pay", "支付"),
    RELATION_BLUE_INVOICE("relationBlueInvoice", "关联蓝票"),
    DELETE("delete", "删除"),
    CANCEL_MATCH_ORDER_AUTO("cancelMatchOrderAuto", "协同取消配单"),
    AUTO_MATCH_ORDER("autoMatchOrder", "协同配单"),
    MODIFY("modify", "运维修改"),
    NEW("new", "新增"),
    CANCEL_MATCH("cancel_match", "取消配单"),
    MANUAL_SEND("manual_send", "手工寄送"),
    AUTO_SEND("auto_send", "自动寄送"),
    MANUAL_SIGN("manual_sign", "人工签核"),
    AUTO_SIGN("auto_sign", "自动签核"),
    WITHDRAW("withdraw", "撤回"),
    MARK("mark", "标记");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceOperation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOperation fromCode(String code){
        switch(code) {
            case "back":
                return BACK;
            case "send":
                return SEND;
            case "sign":
                return SIGN;
            case "acceptRecommendation":
                return ACCEPT_RECOMMENDATION;
            case "manualMatchOrder":
                return MANUAL_MATCH_ORDER;
            case "cancelMatchOrder":
                return CANCEL_MATCH_ORDER;
            case "account":
                return ACCOUNT;
            case "pay":
                return PAY;
            case "relationBlueInvoice":
                return RELATION_BLUE_INVOICE;
            case "delete":
                return DELETE;
            case "cancelMatchOrderAuto":
                return CANCEL_MATCH_ORDER_AUTO;
            case "autoMatchOrder":
                return AUTO_MATCH_ORDER;
            case "modify":
                return MODIFY;
            case "new":
                return NEW;
            case "cancel_match":
                return CANCEL_MATCH;
            case "manual_send":
                return MANUAL_SEND;
            case "auto_send":
                return AUTO_SEND;
            case "manual_sign":
                return MANUAL_SIGN;
            case "auto_sign":
                return AUTO_SIGN;
            case "withdraw":
                return WITHDRAW;
            case "mark":
                return MARK;
            default:
                return null;
        }
    }
}
