package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * prepayment_type
 * </p>
 *
 * @author ultraman
 * @since 2024-08-22
 */
public enum PrepaymentType {

    _0("0", "无类型"),
    _1("1", "诉讼费"),
    _2("2", "备用金"),
    _3("3", "业务保证金（销售）"),
    _4("4", "业务保证金（维保）"),
    _5("5", "其他"),
    _6("6", "押金");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PrepaymentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PrepaymentType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
