package com.xforceplus.ultraman.app.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * todo_type
 * </p>
 *
 * @author ultraman
 * @since 2024-08-22
 */
public enum TodoType {

    VOUCHER("voucher", "发票校验"),
    MATCH("match", "发票配单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TodoType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TodoType fromCode(String code){
        switch(code) {
            case "voucher":
                return VOUCHER;
            case "match":
                return MATCH;
            default:
                return null;
        }
    }
}
