package com.xforceplus.ultraman.app.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-08-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ApprovalTemplate implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 预付款类型
   */
  @TableField("prepaymentType")
  private String prepaymentType;

  /**
   * 保证金类型
   */
  @TableField("bondType")
  private String bondType;

  /**
   * 角色序号
   */
  @TableField("roleSerialNumber")
  private Long roleSerialNumber;

  /**
   * 角色编码
   */
  @TableField("roleType")
  private String roleType;

  /**
   * 角色英文描述
   */
  @TableField("roleEnglishDescription")
  private String roleEnglishDescription;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 有效期下限值
   */
  @TableField("validityPeriodLowerLimit")
  private BigDecimal validityPeriodLowerLimit;

  /**
   * 是否包含有效期下限值
   */
  @TableField("isIncludeValidityPeriodLowerLimit")
  private Boolean isIncludeValidityPeriodLowerLimit;

  /**
   * 有效期上限值
   */
  @TableField("validityPeriodUpperLimit")
  private BigDecimal validityPeriodUpperLimit;

  /**
   * 是否包含有效期上限值
   */
  @TableField("isIncludeValidityPeriodUpperLimit")
  private Boolean isIncludeValidityPeriodUpperLimit;

  /**
   * 金额比例下限值
   */
  @TableField("amountRatioLowerLimit")
  private BigDecimal amountRatioLowerLimit;

  /**
   * 是否包含金额比例下限值
   */
  @TableField("isIncludeAmountRatioLowerLimit")
  private Boolean isIncludeAmountRatioLowerLimit;

  /**
   * 金额比例上限值
   */
  @TableField("amountRatioUpperLimit")
  private BigDecimal amountRatioUpperLimit;

  /**
   * 是否包含金额比例上限值
   */
  @TableField("isIncludeAmountRatioUpperLimit")
  private Boolean isIncludeAmountRatioUpperLimit;

  /**
   * 金额下限值
   */
  @TableField("amountLowerLimit")
  private BigDecimal amountLowerLimit;

  /**
   * 是否包含金额下限值
   */
  @TableField("isIncludeAmountLowerLimit")
  private Boolean isIncludeAmountLowerLimit;

  /**
   * 金额上限值
   */
  @TableField("amountUpperLimit")
  private BigDecimal amountUpperLimit;

  /**
   * 是否包含金额上限值
   */
  @TableField("isIncludeAmountUpperLimit")
  private Boolean isIncludeAmountUpperLimit;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("prepaymentType", prepaymentType);
      map.put("bondType", bondType);
      map.put("roleSerialNumber", roleSerialNumber);
      map.put("roleType", roleType);
      map.put("roleEnglishDescription", roleEnglishDescription);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("validityPeriodLowerLimit", validityPeriodLowerLimit);
      map.put("isIncludeValidityPeriodLowerLimit", isIncludeValidityPeriodLowerLimit);
      map.put("validityPeriodUpperLimit", validityPeriodUpperLimit);
      map.put("isIncludeValidityPeriodUpperLimit", isIncludeValidityPeriodUpperLimit);
      map.put("amountRatioLowerLimit", amountRatioLowerLimit);
      map.put("isIncludeAmountRatioLowerLimit", isIncludeAmountRatioLowerLimit);
      map.put("amountRatioUpperLimit", amountRatioUpperLimit);
      map.put("isIncludeAmountRatioUpperLimit", isIncludeAmountRatioUpperLimit);
      map.put("amountLowerLimit", amountLowerLimit);
      map.put("isIncludeAmountLowerLimit", isIncludeAmountLowerLimit);
      map.put("amountUpperLimit", amountUpperLimit);
      map.put("isIncludeAmountUpperLimit", isIncludeAmountUpperLimit);

      return map;
  }

  public static ApprovalTemplate fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ApprovalTemplate entity = new ApprovalTemplate();
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrepaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBondType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("roleSerialNumber")) {
      Object obj = map.get("roleSerialNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRoleSerialNumber((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRoleSerialNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRoleSerialNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("roleType")) {
      Object obj = map.get("roleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRoleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("roleEnglishDescription")) {
      Object obj = map.get("roleEnglishDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRoleEnglishDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("validityPeriodLowerLimit")) {
      Object obj = map.get("validityPeriodLowerLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setValidityPeriodLowerLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setValidityPeriodLowerLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setValidityPeriodLowerLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setValidityPeriodLowerLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setValidityPeriodLowerLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isIncludeValidityPeriodLowerLimit")) {
      Object obj = map.get("isIncludeValidityPeriodLowerLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsIncludeValidityPeriodLowerLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsIncludeValidityPeriodLowerLimit(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("validityPeriodUpperLimit")) {
      Object obj = map.get("validityPeriodUpperLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setValidityPeriodUpperLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setValidityPeriodUpperLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setValidityPeriodUpperLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setValidityPeriodUpperLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setValidityPeriodUpperLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isIncludeValidityPeriodUpperLimit")) {
      Object obj = map.get("isIncludeValidityPeriodUpperLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsIncludeValidityPeriodUpperLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsIncludeValidityPeriodUpperLimit(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("amountRatioLowerLimit")) {
      Object obj = map.get("amountRatioLowerLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountRatioLowerLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountRatioLowerLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountRatioLowerLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountRatioLowerLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountRatioLowerLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isIncludeAmountRatioLowerLimit")) {
      Object obj = map.get("isIncludeAmountRatioLowerLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsIncludeAmountRatioLowerLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsIncludeAmountRatioLowerLimit(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("amountRatioUpperLimit")) {
      Object obj = map.get("amountRatioUpperLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountRatioUpperLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountRatioUpperLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountRatioUpperLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountRatioUpperLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountRatioUpperLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isIncludeAmountRatioUpperLimit")) {
      Object obj = map.get("isIncludeAmountRatioUpperLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsIncludeAmountRatioUpperLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsIncludeAmountRatioUpperLimit(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("amountLowerLimit")) {
      Object obj = map.get("amountLowerLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountLowerLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountLowerLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountLowerLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountLowerLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountLowerLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isIncludeAmountLowerLimit")) {
      Object obj = map.get("isIncludeAmountLowerLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsIncludeAmountLowerLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsIncludeAmountLowerLimit(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("amountUpperLimit")) {
      Object obj = map.get("amountUpperLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountUpperLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountUpperLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountUpperLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountUpperLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountUpperLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isIncludeAmountUpperLimit")) {
      Object obj = map.get("isIncludeAmountUpperLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsIncludeAmountUpperLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsIncludeAmountUpperLimit(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrepaymentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBondType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("roleSerialNumber")) {
      Object obj = map.get("roleSerialNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRoleSerialNumber((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRoleSerialNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRoleSerialNumber(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("roleType")) {
      Object obj = map.get("roleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRoleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("roleEnglishDescription")) {
      Object obj = map.get("roleEnglishDescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRoleEnglishDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("validityPeriodLowerLimit")) {
      Object obj = map.get("validityPeriodLowerLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setValidityPeriodLowerLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setValidityPeriodLowerLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setValidityPeriodLowerLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setValidityPeriodLowerLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setValidityPeriodLowerLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("isIncludeValidityPeriodLowerLimit")) {
      Object obj = map.get("isIncludeValidityPeriodLowerLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsIncludeValidityPeriodLowerLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsIncludeValidityPeriodLowerLimit(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("validityPeriodUpperLimit")) {
      Object obj = map.get("validityPeriodUpperLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setValidityPeriodUpperLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setValidityPeriodUpperLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setValidityPeriodUpperLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setValidityPeriodUpperLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setValidityPeriodUpperLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("isIncludeValidityPeriodUpperLimit")) {
      Object obj = map.get("isIncludeValidityPeriodUpperLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsIncludeValidityPeriodUpperLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsIncludeValidityPeriodUpperLimit(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("amountRatioLowerLimit")) {
      Object obj = map.get("amountRatioLowerLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountRatioLowerLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountRatioLowerLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountRatioLowerLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountRatioLowerLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountRatioLowerLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("isIncludeAmountRatioLowerLimit")) {
      Object obj = map.get("isIncludeAmountRatioLowerLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsIncludeAmountRatioLowerLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsIncludeAmountRatioLowerLimit(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("amountRatioUpperLimit")) {
      Object obj = map.get("amountRatioUpperLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountRatioUpperLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountRatioUpperLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountRatioUpperLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountRatioUpperLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountRatioUpperLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("isIncludeAmountRatioUpperLimit")) {
      Object obj = map.get("isIncludeAmountRatioUpperLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsIncludeAmountRatioUpperLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsIncludeAmountRatioUpperLimit(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("amountLowerLimit")) {
      Object obj = map.get("amountLowerLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountLowerLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountLowerLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountLowerLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountLowerLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountLowerLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("isIncludeAmountLowerLimit")) {
      Object obj = map.get("isIncludeAmountLowerLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsIncludeAmountLowerLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsIncludeAmountLowerLimit(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("amountUpperLimit")) {
      Object obj = map.get("amountUpperLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountUpperLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountUpperLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountUpperLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountUpperLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountUpperLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("isIncludeAmountUpperLimit")) {
      Object obj = map.get("isIncludeAmountUpperLimit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsIncludeAmountUpperLimit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsIncludeAmountUpperLimit(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
  }
}
