package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * goods_receipt_item
 * </p>
 *
 * @author ultraman
 * @since 2022-02-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsReceiptItem implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 收货单号
   */
  private String grNO;
  /**
   * 序号
   */
  private String itemNO;
  /**
   * SAP项目号
   */
  private String itemSAPNO;
  /**
   * PO号
   */
  private String poNO;
  /**
   * PO对应行号
   */
  private String poLineItemNO;
  /**
   * PO行项目总金额
   */
  private String poLineAmount;
  /**
   * 发票校验数量
   */
  private Long invoiceCheckNO;
  /**
   * 发票校验金额
   */
  private String invoiceCheckAmount;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("grNO", grNO);
      map.put("itemNO", itemNO);
      map.put("itemSAPNO", itemSAPNO);
      map.put("poNO", poNO);
      map.put("poLineItemNO", poLineItemNO);
      map.put("poLineAmount", poLineAmount);
      map.put("invoiceCheckNO", invoiceCheckNO);
      map.put("invoiceCheckAmount", invoiceCheckAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static GoodsReceiptItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsReceiptItem entity = new GoodsReceiptItem();

    if(map.containsKey("grNO")) {
      Object obj = map.get("grNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGrNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNO")) {
      Object obj = map.get("itemNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSAPNO")) {
      Object obj = map.get("itemSAPNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSAPNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNO")) {
      Object obj = map.get("poNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poLineItemNO")) {
      Object obj = map.get("poLineItemNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoLineItemNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poLineAmount")) {
      Object obj = map.get("poLineAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoLineAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCheckNO")) {
      Object obj = map.get("invoiceCheckNO");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceCheckNO((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceCheckNO(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceCheckNO(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCheckAmount")) {
      Object obj = map.get("invoiceCheckAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCheckAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("grNO")) {
      Object obj = map.get("grNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setGrNO((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("itemNO")) {
      Object obj = map.get("itemNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemNO((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("itemSAPNO")) {
      Object obj = map.get("itemSAPNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemSAPNO((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("poNO")) {
      Object obj = map.get("poNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoNO((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("poLineItemNO")) {
      Object obj = map.get("poLineItemNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoLineItemNO((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("poLineAmount")) {
      Object obj = map.get("poLineAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoLineAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceCheckNO")) {
      Object obj = map.get("invoiceCheckNO");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceCheckNO((Long)obj);
        } else if(obj instanceof String) {
            this.setInvoiceCheckNO(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceCheckNO(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceCheckAmount")) {
      Object obj = map.get("invoiceCheckAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCheckAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
