package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * purchase_order_item
 * </p>
 *
 * @author ultraman
 * @since 2022-02-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderItem implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 订单号
   */
  private String poNumber;
  /**
   * 订单行号
   */
  private Long item;
  /**
   * 物料号
   */
  private String materialServices;
  /**
   * 数量
   */
  private String quantity;
  /**
   * 单位
   */
  private String uom;
  /**
   * 要求送货日期
   */
  private String reqDelDate;
  /**
   * 不含税单价
   */
  private String netPriceExVAT;
  /**
   * 价格单位
   */
  private String perUoM;
  /**
   * 税率
   */
  private String vatRate;
  /**
   * 含税小计
   */
  private String totalAmountCNY;
  /**
   * 业务类型
   */
  private String businessType;
  /**
   * WBS
   */
  private String wbs;
  /**
   * 物料名称
   */
  private String materialServicesName;
  /**
   * 币种
   */
  private String currency;
  /**
   * 梯号
   */
  private String ladderNo;
  /**
   * 合同号
   */
  private String contractID;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 梯台状态ID
   */
  private String ladderStatusID;
  /**
   * 梯台状态
   */
  private String ladderStatus;
  /**
   * 税码
   */
  private String vatCode;
  /**
   * 审批状态
   */
  private String approvalStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("item", item);
      map.put("materialServices", materialServices);
      map.put("quantity", quantity);
      map.put("uom", uom);
      map.put("reqDelDate", reqDelDate);
      map.put("netPriceExVAT", netPriceExVAT);
      map.put("perUoM", perUoM);
      map.put("vatRate", vatRate);
      map.put("totalAmountCNY", totalAmountCNY);
      map.put("businessType", businessType);
      map.put("wbs", wbs);
      map.put("materialServicesName", materialServicesName);
      map.put("currency", currency);
      map.put("ladderNo", ladderNo);
      map.put("contractID", contractID);
      map.put("projectName", projectName);
      map.put("ladderStatusID", ladderStatusID);
      map.put("ladderStatus", ladderStatus);
      map.put("vatCode", vatCode);
      map.put("approvalStatus", approvalStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static PurchaseOrderItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderItem entity = new PurchaseOrderItem();

    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uom")) {
      Object obj = map.get("uom");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reqDelDate")) {
      Object obj = map.get("reqDelDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReqDelDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netPriceExVAT")) {
      Object obj = map.get("netPriceExVAT");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetPriceExVAT((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("perUoM")) {
      Object obj = map.get("perUoM");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPerUoM((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatRate")) {
      Object obj = map.get("vatRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountCNY")) {
      Object obj = map.get("totalAmountCNY");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmountCNY((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusID")) {
      Object obj = map.get("ladderStatusID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatusID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatus")) {
      Object obj = map.get("ladderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalStatus")) {
      Object obj = map.get("approvalStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setItem((Long)obj);
        } else if(obj instanceof String) {
            this.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServices((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("uom")) {
      Object obj = map.get("uom");
      if(obj != null) {
        if(obj instanceof String){
            this.setUom((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reqDelDate")) {
      Object obj = map.get("reqDelDate");
      if(obj != null) {
        if(obj instanceof String){
            this.setReqDelDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("netPriceExVAT")) {
      Object obj = map.get("netPriceExVAT");
      if(obj != null) {
        if(obj instanceof String){
            this.setNetPriceExVAT((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("perUoM")) {
      Object obj = map.get("perUoM");
      if(obj != null) {
        if(obj instanceof String){
            this.setPerUoM((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("vatRate")) {
      Object obj = map.get("vatRate");
      if(obj != null) {
        if(obj instanceof String){
            this.setVatRate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalAmountCNY")) {
      Object obj = map.get("totalAmountCNY");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalAmountCNY((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
            this.setWbs((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServicesName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrency((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderStatusID")) {
      Object obj = map.get("ladderStatusID");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderStatusID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderStatus")) {
      Object obj = map.get("ladderStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setVatCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("approvalStatus")) {
      Object obj = map.get("approvalStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setApprovalStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
