package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * account_pay_able
 * </p>
 *
 * @author ultraman
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AccountPayAble implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 申请ID
   */
  private String applyId;
  /**
   * 付款ID
   */
  private String paymentId;
  /**
   * 付款对象
   */
  private String paymentName;
  /**
   * 订单总金额
   */
  private String totalAmount;
  /**
   * 历史已付金额
   */
  private String hisPayAmount;
  /**
   * 发票总金额
   */
  private String invoiceTotalAmount;
  /**
   * 本次结算金额
   */
  private String curSetmentAmount;
  /**
   * 预付款凭证号
   */
  private String advPayVoucherNo;
  /**
   * 预付款金额
   */
  private String advPayAmount;
  /**
   * 本次实付金额
   */
  private String curPayAmount;
  /**
   * 附件
   */
  private String appendDix;
  /**
   * 应付款凭证号
   */
  private String payVoucherNo;
  /**
   * 下载者
   */
  private String downName;
  /**
   * 付款到期日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endPayTime;
  /**
   * 当前审批人
   */
  private String curApprovalName;
  /**
   * 审批历史
   */
  private String hisApprovalMsg;
  /**
   * 文本
   */
  private String textMsg;
  /**
   * 业务单号
   */
  private String businessNo;
  /**
   * 异常信息
   */
  private String exceptMsg;
  /**
   * 扩展字段1
   */
  private String ext1;
  /**
   * 扩展字段2
   */
  private String ext2;
  /**
   * 扩展字段3
   */
  private String ext3;
  /**
   * 扩展字段4
   */
  private String ext4;
  /**
   * 扩展字段5
   */
  private String ext5;
  /**
   * 扩展字段6
   */
  private String ext6;
  /**
   * 扩展字段7
   */
  private String ext7;
  /**
   * 扩展字段8
   */
  private String ext8;
  /**
   * 扩展字段9
   */
  private String ext9;
  /**
   * 扩展字段10
   */
  private String ext10;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 业务类型
   */
  private String businessType;
  /**
   * 供应商租户id
   */
  private String sellerTenantId;
  /**
   * 供应商税号
   */
  private String sellerTaxNo;
  /**
   * 供应商名称
   */
  private String sellerName;
  /**
   * 中心用户分公司租户id
   */
  private String purchaserTenantId;
  /**
   * 中心用户分公司税号
   */
  private String purchaserTaxNo;
  /**
   * 中心用户分公司名
   */
  private String purchaserName;
  /**
   * 付款单类型
   */
  private String paymentType;
  /**
   * 预付类型
   */
  private String prepaymentType;
  /**
   * 代理费类型
   */
  private String agencyFeeType;
  /**
   * 保证金类型
   */
  private String bondType;
  /**
   * 换票类型
   */
  private String changeTicketType;
  /**
   * 当前状态
   */
  private String currentStatus;
  /**
   * 付款人类型
   */
  private String paymentUserType;
  /**
   * 付款银行类型
   */
  private String paymentBankType;
  /**
   * 合同类型
   */
  private String contractType;
  /**
   * 下载状态
   */
  private String downloadStatus;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyId", applyId);
      map.put("paymentId", paymentId);
      map.put("paymentName", paymentName);
      map.put("totalAmount", totalAmount);
      map.put("hisPayAmount", hisPayAmount);
      map.put("invoiceTotalAmount", invoiceTotalAmount);
      map.put("curSetmentAmount", curSetmentAmount);
      map.put("advPayVoucherNo", advPayVoucherNo);
      map.put("advPayAmount", advPayAmount);
      map.put("curPayAmount", curPayAmount);
      map.put("appendDix", appendDix);
      map.put("payVoucherNo", payVoucherNo);
      map.put("downName", downName);
      map.put("endPayTime", BocpGenUtils.toTimestamp(endPayTime));
      map.put("curApprovalName", curApprovalName);
      map.put("hisApprovalMsg", hisApprovalMsg);
      map.put("textMsg", textMsg);
      map.put("businessNo", businessNo);
      map.put("exceptMsg", exceptMsg);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("businessType", businessType);
      map.put("sellerTenantId", sellerTenantId);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("purchaserTenantId", purchaserTenantId);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("paymentType", paymentType);
      map.put("prepaymentType", prepaymentType);
      map.put("agencyFeeType", agencyFeeType);
      map.put("bondType", bondType);
      map.put("changeTicketType", changeTicketType);
      map.put("currentStatus", currentStatus);
      map.put("paymentUserType", paymentUserType);
      map.put("paymentBankType", paymentBankType);
      map.put("contractType", contractType);
      map.put("downloadStatus", downloadStatus);

      return map;
  }

  public static AccountPayAble fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AccountPayAble entity = new AccountPayAble();

    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentId")) {
      Object obj = map.get("paymentId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hisPayAmount")) {
      Object obj = map.get("hisPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHisPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTotalAmount")) {
      Object obj = map.get("invoiceTotalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curSetmentAmount")) {
      Object obj = map.get("curSetmentAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurSetmentAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("advPayVoucherNo")) {
      Object obj = map.get("advPayVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAdvPayVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("advPayAmount")) {
      Object obj = map.get("advPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAdvPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curPayAmount")) {
      Object obj = map.get("curPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appendDix")) {
      Object obj = map.get("appendDix");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAppendDix((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payVoucherNo")) {
      Object obj = map.get("payVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downName")) {
      Object obj = map.get("downName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endPayTime")) {
      Object obj = map.get("endPayTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndPayTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndPayTime(null);
      }
    }
    if(map.containsKey("curApprovalName")) {
      Object obj = map.get("curApprovalName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurApprovalName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hisApprovalMsg")) {
      Object obj = map.get("hisApprovalMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHisApprovalMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("textMsg")) {
      Object obj = map.get("textMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTextMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessNo")) {
      Object obj = map.get("businessNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exceptMsg")) {
      Object obj = map.get("exceptMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agencyFeeType")) {
      Object obj = map.get("agencyFeeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgencyFeeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBondType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeTicketType")) {
      Object obj = map.get("changeTicketType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChangeTicketType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentStatus")) {
      Object obj = map.get("currentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUserType")) {
      Object obj = map.get("paymentUserType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUserType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentBankType")) {
      Object obj = map.get("paymentBankType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentBankType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadStatus")) {
      Object obj = map.get("downloadStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentId")) {
      Object obj = map.get("paymentId");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hisPayAmount")) {
      Object obj = map.get("hisPayAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setHisPayAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceTotalAmount")) {
      Object obj = map.get("invoiceTotalAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceTotalAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("curSetmentAmount")) {
      Object obj = map.get("curSetmentAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurSetmentAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("advPayVoucherNo")) {
      Object obj = map.get("advPayVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setAdvPayVoucherNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("advPayAmount")) {
      Object obj = map.get("advPayAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setAdvPayAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("curPayAmount")) {
      Object obj = map.get("curPayAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurPayAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("appendDix")) {
      Object obj = map.get("appendDix");
      if(obj != null) {
        if(obj instanceof String){
            this.setAppendDix((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payVoucherNo")) {
      Object obj = map.get("payVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPayVoucherNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("downName")) {
      Object obj = map.get("downName");
      if(obj != null) {
        if(obj instanceof String){
            this.setDownName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("endPayTime")) {
      Object obj = map.get("endPayTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndPayTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setEndPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndPayTime(null);
      }
   }
    if(map.containsKey("curApprovalName")) {
      Object obj = map.get("curApprovalName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurApprovalName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hisApprovalMsg")) {
      Object obj = map.get("hisApprovalMsg");
      if(obj != null) {
        if(obj instanceof String){
            this.setHisApprovalMsg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("textMsg")) {
      Object obj = map.get("textMsg");
      if(obj != null) {
        if(obj instanceof String){
            this.setTextMsg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessNo")) {
      Object obj = map.get("businessNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("exceptMsg")) {
      Object obj = map.get("exceptMsg");
      if(obj != null) {
        if(obj instanceof String){
            this.setExceptMsg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt3((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt4((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt5((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt6((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt7((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt8((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt9((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt10((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTenantId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTenantId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrepaymentType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("agencyFeeType")) {
      Object obj = map.get("agencyFeeType");
      if(obj != null) {
        if(obj instanceof String){
            this.setAgencyFeeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBondType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("changeTicketType")) {
      Object obj = map.get("changeTicketType");
      if(obj != null) {
        if(obj instanceof String){
            this.setChangeTicketType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currentStatus")) {
      Object obj = map.get("currentStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrentStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentUserType")) {
      Object obj = map.get("paymentUserType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentUserType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentBankType")) {
      Object obj = map.get("paymentBankType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentBankType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("downloadStatus")) {
      Object obj = map.get("downloadStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setDownloadStatus((String)obj);
        }
      } else{
      }
   }

  }

}
