package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_notice_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceNoticeBill implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 业务单类型
   */
  private String businessType;
  /**
   * 销方编号
   */
  private String sellerID;
  /**
   * 购方编号
   */
  private String buyerID;
  /**
   * 不含税总金额
   */
  private String totalAmount;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 购方名称
   */
  private String buyerName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 前置单据号
   */
  private String preNo;
  /**
   * 分期数
   */
  private Long installmentNum;
  /**
   * 含税总金额
   */
  private String totalAmountWithTax;
  /**
   * 发票备注
   */
  private String invoiceRemark;
  /**
   * 计价方式 （0-不含税价 1-含税价）
   */
  private String priceMethod;
  /**
   * 税额
   */
  private String taxAmount;
  /**
   * 物料号
   */
  private String materialServices;
  /**
   * 物料名称
   */
  private String materialServicesName;
  /**
   * WBS
   */
  private String wbs;
  /**
   * 梯号
   */
  private String ladderNo;
  /**
   * 币种
   */
  private String currency;
  /**
   * 节点
   */
  private String node;
  /**
   * 已发货数量
   */
  private BigDecimal hippedQuantity;
  /**
   * 开票通知单号
   */
  private String invoiceNoticeNO;
  /**
   * 采购组编码
   */
  private String purchaseGroupCode;
  /**
   * 采购组名称
   */
  private String purchaseGroupName;
  /**
   * 采购组织编码
   */
  private String purchaseOrgCode;
  /**
   * 采购组织名称
   */
  private String purchaseOrgName;
  /**
   * 分公司抬头
   */
  private String branchCompanyHeader;
  /**
   * 分公司名称
   */
  private String branchCompanyName;
  /**
   * 购方税号
   */
  private String sellerTaxNo;
  /**
   * 购方税号
   */
  private String buyerTaxNo;
  /**
   * 状态
   */
  private String status;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceType", invoiceType);
      map.put("businessType", businessType);
      map.put("sellerID", sellerID);
      map.put("buyerID", buyerID);
      map.put("totalAmount", totalAmount);
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("preNo", preNo);
      map.put("installmentNum", installmentNum);
      map.put("totalAmountWithTax", totalAmountWithTax);
      map.put("invoiceRemark", invoiceRemark);
      map.put("priceMethod", priceMethod);
      map.put("taxAmount", taxAmount);
      map.put("materialServices", materialServices);
      map.put("materialServicesName", materialServicesName);
      map.put("wbs", wbs);
      map.put("ladderNo", ladderNo);
      map.put("currency", currency);
      map.put("node", node);
      map.put("hippedQuantity", hippedQuantity);
      map.put("invoiceNoticeNO", invoiceNoticeNO);
      map.put("purchaseGroupCode", purchaseGroupCode);
      map.put("purchaseGroupName", purchaseGroupName);
      map.put("purchaseOrgCode", purchaseOrgCode);
      map.put("purchaseOrgName", purchaseOrgName);
      map.put("branchCompanyHeader", branchCompanyHeader);
      map.put("branchCompanyName", branchCompanyName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("status", status);

      return map;
  }

  public static InvoiceNoticeBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceNoticeBill entity = new InvoiceNoticeBill();

    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerID")) {
      Object obj = map.get("sellerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preNo")) {
      Object obj = map.get("preNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("installmentNum")) {
      Object obj = map.get("installmentNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInstallmentNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setInstallmentNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInstallmentNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountWithTax")) {
      Object obj = map.get("totalAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceRemark")) {
      Object obj = map.get("invoiceRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("node")) {
      Object obj = map.get("node");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hippedQuantity")) {
      Object obj = map.get("hippedQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setHippedQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setHippedQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setHippedQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setHippedQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setHippedQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNO")) {
      Object obj = map.get("invoiceNoticeNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseGroupCode")) {
      Object obj = map.get("purchaseGroupCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseGroupName")) {
      Object obj = map.get("purchaseGroupName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrgCode")) {
      Object obj = map.get("purchaseOrgCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrgName")) {
      Object obj = map.get("purchaseOrgName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchCompanyHeader")) {
      Object obj = map.get("branchCompanyHeader");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBranchCompanyHeader((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchCompanyName")) {
      Object obj = map.get("branchCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBranchCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerID")) {
      Object obj = map.get("sellerID");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("preNo")) {
      Object obj = map.get("preNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("installmentNum")) {
      Object obj = map.get("installmentNum");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInstallmentNum((Long)obj);
        } else if(obj instanceof String) {
            this.setInstallmentNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInstallmentNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("totalAmountWithTax")) {
      Object obj = map.get("totalAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalAmountWithTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceRemark")) {
      Object obj = map.get("invoiceRemark");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
            this.setPriceMethod((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServices((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServicesName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
            this.setWbs((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrency((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("node")) {
      Object obj = map.get("node");
      if(obj != null) {
        if(obj instanceof String){
            this.setNode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hippedQuantity")) {
      Object obj = map.get("hippedQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setHippedQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setHippedQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setHippedQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setHippedQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setHippedQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeNO")) {
      Object obj = map.get("invoiceNoticeNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNoticeNO((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseGroupCode")) {
      Object obj = map.get("purchaseGroupCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseGroupCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseGroupName")) {
      Object obj = map.get("purchaseGroupName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseGroupName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseOrgCode")) {
      Object obj = map.get("purchaseOrgCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseOrgCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseOrgName")) {
      Object obj = map.get("purchaseOrgName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseOrgName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("branchCompanyHeader")) {
      Object obj = map.get("branchCompanyHeader");
      if(obj != null) {
        if(obj instanceof String){
            this.setBranchCompanyHeader((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("branchCompanyName")) {
      Object obj = map.get("branchCompanyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setBranchCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatus((String)obj);
        }
      } else{
      }
   }

  }

}
