package com.xforceplus.ultraman.app.jctke.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2022-03-23
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1494229217612763138L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface PurchaseOrder {
        static Long id() {
            return 1494505043025924097L;
        }
        static String code() {
            return "purchaseOrder";
        }
        TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poNumber");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PAYMENT_TERM = new TypedField<>(String.class, "paymentTerm");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> LICENSE_ADDRESS = new TypedField<>(String.class, "licenseAddress");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> PAYED_AMOUNT = new TypedField<>(String.class, "payedAmount");
        TypedField<String> INVOICED_AMOUNT = new TypedField<>(String.class, "invoicedAmount");
        TypedField<String> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(String.class, "waitForInvoiceAmount");
        TypedField<String> DELIVERIED_AMOUNT = new TypedField<>(String.class, "deliveriedAmount");
        TypedField<String> PREPAY_AMOUNT = new TypedField<>(String.class, "prepayAmount");
        TypedField<String> UNPAYED_AMOUNT = new TypedField<>(String.class, "unpayedAmount");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> PO_VERSION = new TypedField<>(String.class, "poVersion");
        TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "failureReason");
        TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchasingTeam");
        TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchasingOrg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> PREPAID_AMOUNT = new TypedField<>(String.class, "prepaidAmount");
        TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "buyerInvoiceID");
        TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "buyerInvoiceTitle");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<Boolean> IS_COORD = new TypedField<>(Boolean.class, "isCoord");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface PurchaseOrderItem {
        static Long id() {
            return 1494505580509204481L;
        }
        static String code() {
            return "purchaseOrderItem";
        }
        TypedField<String> PO_NUMBER = new TypedField<>(String.class, "poNumber");
        TypedField<Long> ITEM = new TypedField<>(Long.class, "item");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UOM = new TypedField<>(String.class, "uom");
        TypedField<String> REQ_DEL_DATE = new TypedField<>(String.class, "reqDelDate");
        TypedField<String> NET_PRICE_EX_V_A_T = new TypedField<>(String.class, "netPriceExVAT");
        TypedField<String> PER_UO_M = new TypedField<>(String.class, "perUoM");
        TypedField<String> VAT_RATE = new TypedField<>(String.class, "vatRate");
        TypedField<String> TOTAL_AMOUNT_C_N_Y = new TypedField<>(String.class, "totalAmountCNY");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> CONTRACT_I_D = new TypedField<>(String.class, "contractID");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> LADDER_STATUS_I_D = new TypedField<>(String.class, "ladderStatusID");
        TypedField<String> LADDER_STATUS = new TypedField<>(String.class, "ladderStatus");
        TypedField<String> VAT_CODE = new TypedField<>(String.class, "vatCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MATERIAL_SERVICES_TEAM = new TypedField<>(String.class, "materialServicesTeam");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PROFITS_CENTER = new TypedField<>(String.class, "profitsCenter");
        TypedField<String> GENERAL_LEDGER_ACCOUNT = new TypedField<>(String.class, "generalLedgerAccount");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> RECEIVED_COUNT = new TypedField<>(String.class, "receivedCount");
        TypedField<String> RELEASE_STATUS = new TypedField<>(String.class, "releaseStatus");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> NODE = new TypedField<>(String.class, "node");
        /**
         * 对一关联关系 关联对象 purchaseOrder
         */
        TypedField<Long> PURCHASE_ORDER_ITEM_RELATION_ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PURCHASE_ORDER_ITEM_RELATION {
                static String code () {
                    return "purchaseOrderItemRelation" ;
                }
                TypedField<String> PO_NUMBER = new TypedField<>(String.class, "purchaseOrderItemRelation.poNumber");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.sellerName");
                TypedField<String> PAYMENT_TERM = new TypedField<>(String.class, "purchaseOrderItemRelation.paymentTerm");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.buyerName");
                TypedField<String> LICENSE_ADDRESS = new TypedField<>(String.class, "purchaseOrderItemRelation.licenseAddress");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "purchaseOrderItemRelation.businessType");
                TypedField<String> AMOUNT = new TypedField<>(String.class, "purchaseOrderItemRelation.amount");
                TypedField<String> PAYED_AMOUNT = new TypedField<>(String.class, "purchaseOrderItemRelation.payedAmount");
                TypedField<String> INVOICED_AMOUNT = new TypedField<>(String.class, "purchaseOrderItemRelation.invoicedAmount");
                TypedField<String> WAIT_FOR_INVOICE_AMOUNT = new TypedField<>(String.class, "purchaseOrderItemRelation.waitForInvoiceAmount");
                TypedField<String> DELIVERIED_AMOUNT = new TypedField<>(String.class, "purchaseOrderItemRelation.deliveriedAmount");
                TypedField<String> PREPAY_AMOUNT = new TypedField<>(String.class, "purchaseOrderItemRelation.prepayAmount");
                TypedField<String> UNPAYED_AMOUNT = new TypedField<>(String.class, "purchaseOrderItemRelation.unpayedAmount");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "purchaseOrderItemRelation.orderType");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "purchaseOrderItemRelation.buyerID");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "purchaseOrderItemRelation.orderStatus");
                TypedField<String> PO_VERSION = new TypedField<>(String.class, "purchaseOrderItemRelation.poVersion");
                TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "purchaseOrderItemRelation.failureReason");
                TypedField<String> PURCHASING_TEAM = new TypedField<>(String.class, "purchaseOrderItemRelation.purchasingTeam");
                TypedField<String> PURCHASING_ORG = new TypedField<>(String.class, "purchaseOrderItemRelation.purchasingOrg");
                TypedField<Long> ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "purchaseOrderItemRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderItemRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrderItemRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "purchaseOrderItemRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "purchaseOrderItemRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "purchaseOrderItemRelation.delete_flag");
                TypedField<String> EXT1 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "purchaseOrderItemRelation.ext10");
                TypedField<String> PREPAID_AMOUNT = new TypedField<>(String.class, "purchaseOrderItemRelation.prepaidAmount");
                TypedField<String> BUYER_INVOICE_I_D = new TypedField<>(String.class, "purchaseOrderItemRelation.buyerInvoiceID");
                TypedField<String> BUYER_INVOICE_TITLE = new TypedField<>(String.class, "purchaseOrderItemRelation.buyerInvoiceTitle");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "purchaseOrderItemRelation.amountWithTax");
                TypedField<Boolean> IS_COORD = new TypedField<>(Boolean.class, "purchaseOrderItemRelation.isCoord");
            }
        }
    }
    public interface GoodsReceipt {
        static Long id() {
            return 1494506057145716738L;
        }
        static String code() {
            return "goodsReceipt";
        }
        TypedField<String> GR_N_O = new TypedField<>(String.class, "grNO");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "failureReason");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface GoodsReceiptItem {
        static Long id() {
            return 1494506416052310018L;
        }
        static String code() {
            return "goodsReceiptItem";
        }
        TypedField<String> GR_N_O = new TypedField<>(String.class, "grNO");
        TypedField<String> ITEM_N_O = new TypedField<>(String.class, "itemNO");
        TypedField<String> PO_N_O = new TypedField<>(String.class, "poNO");
        TypedField<String> PO_LINE_ITEM_N_O = new TypedField<>(String.class, "poLineItemNO");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        /**
         * 对一关联关系 关联对象 goodsReceipt
         */
        TypedField<Long> RECEIVE_ORDER_ITEM_RELATION_ID = new TypedField<>(Long.class, "receiveOrderItemRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface RECEIVE_ORDER_ITEM_RELATION {
                static String code () {
                    return "receiveOrderItemRelation" ;
                }
                TypedField<String> GR_N_O = new TypedField<>(String.class, "receiveOrderItemRelation.grNO");
                TypedField<Long> ID = new TypedField<>(Long.class, "receiveOrderItemRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "receiveOrderItemRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "receiveOrderItemRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "receiveOrderItemRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "receiveOrderItemRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "receiveOrderItemRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "receiveOrderItemRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "receiveOrderItemRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "receiveOrderItemRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "receiveOrderItemRelation.delete_flag");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "receiveOrderItemRelation.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "receiveOrderItemRelation.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "receiveOrderItemRelation.buyerName");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "receiveOrderItemRelation.buyerID");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "receiveOrderItemRelation.orderStatus");
                TypedField<String> FAILURE_REASON = new TypedField<>(String.class, "receiveOrderItemRelation.failureReason");
                TypedField<String> REMARK = new TypedField<>(String.class, "receiveOrderItemRelation.remark");
            }
        }
    }
    public interface InvoiceNoticeBill {
        static Long id() {
            return 1494506942278078465L;
        }
        static String code() {
            return "invoiceNoticeBill";
        }
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> SELLER_I_D = new TypedField<>(String.class, "sellerID");
        TypedField<String> BUYER_I_D = new TypedField<>(String.class, "buyerID");
        TypedField<String> TOTAL_AMOUNT = new TypedField<>(String.class, "totalAmount");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRE_NO = new TypedField<>(String.class, "preNo");
        TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "installmentNum");
        TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "totalAmountWithTax");
        TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceRemark");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "materialServices");
        TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "materialServicesName");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> NODE = new TypedField<>(String.class, "node");
        TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "hippedQuantity");
        TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeNO");
        TypedField<String> PURCHASE_GROUP_CODE = new TypedField<>(String.class, "purchaseGroupCode");
        TypedField<String> PURCHASE_GROUP_NAME = new TypedField<>(String.class, "purchaseGroupName");
        TypedField<String> PURCHASE_ORG_CODE = new TypedField<>(String.class, "purchaseOrgCode");
        TypedField<String> PURCHASE_ORG_NAME = new TypedField<>(String.class, "purchaseOrgName");
        TypedField<String> BRANCH_COMPANY_HEADER = new TypedField<>(String.class, "branchCompanyHeader");
        TypedField<String> BRANCH_COMPANY_NAME = new TypedField<>(String.class, "branchCompanyName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InvoiceNoticeBillItem {
        static Long id() {
            return 1504005379973025794L;
        }
        static String code() {
            return "invoiceNoticeBillItem";
        }
        TypedField<String> ITEM_N_O = new TypedField<>(String.class, "itemNO");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unitPriceWithTax");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unitPrice");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeNO");
        TypedField<String> BILL_N_O = new TypedField<>(String.class, "billNO");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> WBS = new TypedField<>(String.class, "wbs");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> VIEW_ID = new TypedField<>(String.class, "viewId");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> LADDER_NO = new TypedField<>(String.class, "ladderNo");
        TypedField<String> LADDER_STATUS = new TypedField<>(String.class, "ladderStatus");
        TypedField<String> PM_NODE = new TypedField<>(String.class, "pmNode");
        /**
         * 对一关联关系 关联对象 invoiceNoticeBill
         */
        TypedField<Long> INVOICE_NOTICE_BILL_AND_ITEM_RELATION_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_NOTICE_BILL_AND_ITEM_RELATION {
                static String code () {
                    return "invoiceNoticeBillAndItemRelation" ;
                }
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoiceType");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.businessType");
                TypedField<String> SELLER_I_D = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerID");
                TypedField<String> BUYER_I_D = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.buyerID");
                TypedField<String> TOTAL_AMOUNT = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.totalAmount");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerName");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.buyerName");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillAndItemRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceNoticeBillAndItemRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.delete_flag");
                TypedField<String> PRE_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.preNo");
                TypedField<Long> INSTALLMENT_NUM = new TypedField<>(Long.class, "invoiceNoticeBillAndItemRelation.installmentNum");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.totalAmountWithTax");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoiceRemark");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.priceMethod");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.taxAmount");
                TypedField<String> MATERIAL_SERVICES = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.materialServices");
                TypedField<String> MATERIAL_SERVICES_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.materialServicesName");
                TypedField<String> WBS = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.wbs");
                TypedField<String> LADDER_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.ladderNo");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.currency");
                TypedField<String> NODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.node");
                TypedField<BigDecimal> HIPPED_QUANTITY = new TypedField<>(BigDecimal.class, "invoiceNoticeBillAndItemRelation.hippedQuantity");
                TypedField<String> INVOICE_NOTICE_N_O = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.invoiceNoticeNO");
                TypedField<String> PURCHASE_GROUP_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaseGroupCode");
                TypedField<String> PURCHASE_GROUP_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaseGroupName");
                TypedField<String> PURCHASE_ORG_CODE = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaseOrgCode");
                TypedField<String> PURCHASE_ORG_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.purchaseOrgName");
                TypedField<String> BRANCH_COMPANY_HEADER = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.branchCompanyHeader");
                TypedField<String> BRANCH_COMPANY_NAME = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.branchCompanyName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.sellerTaxNo");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.buyerTaxNo");
                TypedField<String> STATUS = new TypedField<>(String.class, "invoiceNoticeBillAndItemRelation.status");
            }
        }
    }
    public interface AccountPayAble {
        static Long id() {
            return 1504027037098151938L;
        }
        static String code() {
            return "accountPayAble";
        }
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<String> PAYMENT_ID = new TypedField<>(String.class, "paymentId");
        TypedField<String> PAYMENT_NAME = new TypedField<>(String.class, "paymentName");
        TypedField<String> TOTAL_AMOUNT = new TypedField<>(String.class, "totalAmount");
        TypedField<String> HIS_PAY_AMOUNT = new TypedField<>(String.class, "hisPayAmount");
        TypedField<String> INVOICE_TOTAL_AMOUNT = new TypedField<>(String.class, "invoiceTotalAmount");
        TypedField<String> CUR_SETMENT_AMOUNT = new TypedField<>(String.class, "curSetmentAmount");
        TypedField<String> ADV_PAY_VOUCHER_NO = new TypedField<>(String.class, "advPayVoucherNo");
        TypedField<String> ADV_PAY_AMOUNT = new TypedField<>(String.class, "advPayAmount");
        TypedField<String> CUR_PAY_AMOUNT = new TypedField<>(String.class, "curPayAmount");
        TypedField<String> APPEND_DIX = new TypedField<>(String.class, "appendDix");
        TypedField<String> PAY_VOUCHER_NO = new TypedField<>(String.class, "payVoucherNo");
        TypedField<String> DOWN_NAME = new TypedField<>(String.class, "downName");
        TypedField<LocalDateTime> END_PAY_TIME = new TypedField<>(LocalDateTime.class, "endPayTime");
        TypedField<String> CUR_APPROVAL_NAME = new TypedField<>(String.class, "curApprovalName");
        TypedField<String> HIS_APPROVAL_MSG = new TypedField<>(String.class, "hisApprovalMsg");
        TypedField<String> TEXT_MSG = new TypedField<>(String.class, "textMsg");
        TypedField<String> BUSINESS_NO = new TypedField<>(String.class, "businessNo");
        TypedField<String> EXCEPT_MSG = new TypedField<>(String.class, "exceptMsg");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "sellerTenantId");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "purchaserTenantId");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "prepaymentType");
        TypedField<String> AGENCY_FEE_TYPE = new TypedField<>(String.class, "agencyFeeType");
        TypedField<String> BOND_TYPE = new TypedField<>(String.class, "bondType");
        TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "changeTicketType");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "paymentUserType");
        TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "paymentBankType");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "downloadStatus");
    }
    public interface Invoice {
        static Long id() {
            return 1504276669632286721L;
        }
        static String code() {
            return "invoice";
        }
        TypedField<String> PRE_N_O = new TypedField<>(String.class, "preNO");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceUrl");
        TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "paperDrawDate");
        TypedField<LocalDateTime> SEND_DATE = new TypedField<>(LocalDateTime.class, "sendDate");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> SUBMIT_DATE = new TypedField<>(LocalDateTime.class, "submitDate");
        TypedField<LocalDateTime> POSTING_DATE = new TypedField<>(LocalDateTime.class, "postingDate");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentDate");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EXPRESS_NUMBER = new TypedField<>(String.class, "expressNumber");
        TypedField<String> VERSION = new TypedField<>(String.class, "version");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> PAYABLE_VOUCHER_NUMBERS = new TypedField<>(String.class, "payableVoucherNumbers");
    }
    public interface TaxCode {
        static Long id() {
            return 1505797273594068993L;
        }
        static String code() {
            return "taxCode";
        }
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_CODE = new TypedField<>(String.class, "taxCode");
    }
    public interface SubeiAmountApproval {
        static Long id() {
            return 1505804192207568898L;
        }
        static String code() {
            return "subeiAmountApproval";
        }
        TypedField<String> EXPENSE_TYPE = new TypedField<>(String.class, "expenseType");
        TypedField<String> ROLE_TYPE = new TypedField<>(String.class, "roleType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ToubaoAmountApproval {
        static Long id() {
            return 1505819069571629058L;
        }
        static String code() {
            return "toubaoAmountApproval";
        }
        TypedField<Long> EXPIRE_DAYS = new TypedField<>(Long.class, "expireDays");
        TypedField<String> ROLE_TYPE = new TypedField<>(String.class, "roleType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface WeiAmountApproval {
        static Long id() {
            return 1505820212225867777L;
        }
        static String code() {
            return "weiAmountApproval";
        }
        TypedField<String> EXPENSE_TYPE = new TypedField<>(String.class, "expenseType");
        TypedField<String> PROPORTION = new TypedField<>(String.class, "proportion");
        TypedField<String> MARGIN_AMOUNT = new TypedField<>(String.class, "marginAmount");
        TypedField<Long> EXPIRE_DAYS = new TypedField<>(Long.class, "expireDays");
        TypedField<String> ROLE_TYPE = new TypedField<>(String.class, "roleType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface RpaTask {
        static Long id() {
            return 1505822804926496770L;
        }
        static String code() {
            return "rpaTask";
        }
        TypedField<String> TASK_TYPE = new TypedField<>(String.class, "taskType");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<LocalDateTime> WAREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "warehousingTime");
        TypedField<String> RESQUST_BODY = new TypedField<>(String.class, "resqustBody");
        TypedField<String> RESQUST_STATUS = new TypedField<>(String.class, "resqustStatus");
        TypedField<String> REPONSE_BODY = new TypedField<>(String.class, "reponseBody");
        TypedField<LocalDateTime> REPONSE_TIME = new TypedField<>(LocalDateTime.class, "reponseTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TASK_NO = new TypedField<>(String.class, "taskNo");
    }
    public interface ArPowerBi {
        static Long id() {
            return 1505829103252766722L;
        }
        static String code() {
            return "arPowerBi";
        }
        TypedField<String> COLLECTION_PERCENT = new TypedField<>(String.class, "collectionPercent");
        TypedField<String> PAYMENT_PERCENT = new TypedField<>(String.class, "paymentPercent");
        TypedField<LocalDateTime> AREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "arehousingTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
    }
    public interface ProfitCenterCompany {
        static Long id() {
            return 1505830140470591490L;
        }
        static String code() {
            return "profitCenterCompany";
        }
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> TAX_BRANCH = new TypedField<>(String.class, "taxBranch");
        TypedField<String> PERFORMANCE_BRANCH = new TypedField<>(String.class, "performanceBranch");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface AdvanceChargeInterface {
        static Long id() {
            return 1505838263969218561L;
        }
        static String code() {
            return "advanceChargeInterface";
        }
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "paymentNo");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<LocalDateTime> PAYMENT_TIME = new TypedField<>(LocalDateTime.class, "paymentTime");
        TypedField<LocalDateTime> PAYMENT_MONTH = new TypedField<>(LocalDateTime.class, "paymentMonth");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> PO_NO = new TypedField<>(String.class, "poNo");
        TypedField<String> SUPPLIER_ID = new TypedField<>(String.class, "supplierId");
        TypedField<String> LEDGER_TYPE = new TypedField<>(String.class, "ledgerType");
        TypedField<String> EXCHANGE_RATE = new TypedField<>(String.class, "exchangeRate");
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> TAX_CODE = new TypedField<>(String.class, "taxCode");
        TypedField<String> TEXT = new TypedField<>(String.class, "text");
        TypedField<String> ADVANCE_CHARGE_AMOUNT = new TypedField<>(String.class, "advanceChargeAmount");
        TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "paymentDueDate");
        TypedField<LocalDateTime> WAREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "warehousingTime");
        TypedField<String> RPA_TASK_ID = new TypedField<>(String.class, "rpaTaskId");
        TypedField<String> PRE_PAYMENT_NO = new TypedField<>(String.class, "prePaymentNo");
        TypedField<String> PRE_PAYMENT_VOUCHER_NO = new TypedField<>(String.class, "prePaymentVoucherNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface AccountsPayableInterface {
        static Long id() {
            return 1505845707520835585L;
        }
        static String code() {
            return "accountsPayableInterface";
        }
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "paymentNo");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> PRE_PAYMENT_IDENTIFICATION = new TypedField<>(String.class, "prePaymentIdentification");
        TypedField<String> PRE_PAYMENT_VOUCHER_NO = new TypedField<>(String.class, "prePaymentVoucherNo");
        TypedField<String> PRE_PAYMENT_AMOUNT = new TypedField<>(String.class, "prePaymentAmount");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paperDrewDate");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> PO_LIST = new TypedField<>(String.class, "poList");
        TypedField<String> IS_FROZEN = new TypedField<>(String.class, "isFrozen");
        TypedField<String> PAYMENT_VOUCHER_NO = new TypedField<>(String.class, "paymentVoucherNo");
        TypedField<String> REVERSE_ORDER_VOUCHER_NO = new TypedField<>(String.class, "reverseOrderVoucherNo");
        TypedField<String> PRE_PAYMENT = new TypedField<>(String.class, "prePayment");
        TypedField<String> PAYMENT_VOUCHER_NO_TWO = new TypedField<>(String.class, "paymentVoucherNoTwo");
        TypedField<String> SETTLE_ACCOUNTS_VOUCHER_NO = new TypedField<>(String.class, "settleAccountsVoucherNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RPA_TASK_ID = new TypedField<>(String.class, "rpaTaskId");
        TypedField<LocalDateTime> WAREHOUSING_TIME = new TypedField<>(LocalDateTime.class, "warehousingTime");
    }
    public interface ApprovalHistory {
        static Long id() {
            return 1505847510303997953L;
        }
        static String code() {
            return "approvalHistory";
        }
        TypedField<String> APPROVAL_ID = new TypedField<>(String.class, "approvalId");
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<String> APPROVAL_USER_NAME = new TypedField<>(String.class, "approvalUserName");
        TypedField<String> APPROVAL_STATUS = new TypedField<>(String.class, "approvalStatus");
        TypedField<String> APPROVAL_BODY = new TypedField<>(String.class, "approvalBody");
        TypedField<String> APPLY_NO = new TypedField<>(String.class, "applyNo");
        TypedField<LocalDateTime> APPROVAL_TIME = new TypedField<>(LocalDateTime.class, "approvalTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface Enclosure {
        static Long id() {
            return 1505848133372051458L;
        }
        static String code() {
            return "enclosure";
        }
        TypedField<String> APPLY_NO = new TypedField<>(String.class, "applyNo");
        TypedField<String> FILE_ID = new TypedField<>(String.class, "fileId");
        TypedField<String> FILE_NAME = new TypedField<>(String.class, "fileName");
        TypedField<String> FILE_URL = new TypedField<>(String.class, "fileUrl");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface PaymentManage {
        static Long id() {
            return 1506102729814511617L;
        }
        static String code() {
            return "paymentManage";
        }
        TypedField<String> APPLY_ID = new TypedField<>(String.class, "applyId");
        TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "applyUserName");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "businessType");
        TypedField<String> PREPAYMENT_TYPE = new TypedField<>(String.class, "prepaymentType");
        TypedField<String> AGENCY_FEE_TYPE = new TypedField<>(String.class, "agencyFeeType");
        TypedField<String> BOND_TYPE = new TypedField<>(String.class, "bondType");
        TypedField<String> CHANGE_TICKET_TYPE = new TypedField<>(String.class, "changeTicketType");
        TypedField<String> PROCUREMENT_GROUP = new TypedField<>(String.class, "procurementGroup");
        TypedField<String> PAYMENT_OBJECT_ID = new TypedField<>(String.class, "paymentObjectId");
        TypedField<String> PAYMENT_OBJECT = new TypedField<>(String.class, "paymentObject");
        TypedField<String> APPLY_PAYMENT_AMOUNT = new TypedField<>(String.class, "applyPaymentAmount");
        TypedField<String> APPLY_PAID_AMOUNT = new TypedField<>(String.class, "applyPaidAmount");
        TypedField<String> ORDER_AMOUNT = new TypedField<>(String.class, "orderAmount");
        TypedField<String> INVOICE_AMOUNT = new TypedField<>(String.class, "invoiceAmount");
        TypedField<String> PREPAYMENT_AMOUNT = new TypedField<>(String.class, "prepaymentAmount");
        TypedField<String> COLLECTION_ACCUMULATION = new TypedField<>(String.class, "collectionAccumulation");
        TypedField<String> PAYMENT_ACCUMULATION = new TypedField<>(String.class, "paymentAccumulation");
        TypedField<String> PREPAYMENT_REQUEST_NO = new TypedField<>(String.class, "prepaymentRequestNo");
        TypedField<String> PREPAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "prepaymentPaymentVoucher");
        TypedField<String> PREPAYMENT_WRITE_VOUCHER = new TypedField<>(String.class, "prepaymentWriteVoucher");
        TypedField<String> PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentVoucher");
        TypedField<String> PAYMENT_PAYMENT_VOUCHER = new TypedField<>(String.class, "paymentPaymentVoucher");
        TypedField<String> PAYMENT_CLEARING_VOUCHER = new TypedField<>(String.class, "paymentClearingVoucher");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<String> PROFIT_CENTER = new TypedField<>(String.class, "profitCenter");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PAYMENT_USER_TYPE = new TypedField<>(String.class, "paymentUserType");
        TypedField<LocalDateTime> PAYMENT_DUE_DATE = new TypedField<>(LocalDateTime.class, "paymentDueDate");
        TypedField<String> PAYMENT_BANK_TYPE = new TypedField<>(String.class, "paymentBankType");
        TypedField<String> COLLECTION_BANK = new TypedField<>(String.class, "collectionBank");
        TypedField<String> COLLECTION_ACCOUNT = new TypedField<>(String.class, "collectionAccount");
        TypedField<String> COLLECTION_NAME = new TypedField<>(String.class, "collectionName");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "contractName");
        TypedField<String> CONTRACT_AMOUNT = new TypedField<>(String.class, "contractAmount");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> FILE = new TypedField<>(String.class, "file");
        TypedField<String> TEXT = new TypedField<>(String.class, "text");
        TypedField<String> PAYMENT_REMARK = new TypedField<>(String.class, "paymentRemark");
        TypedField<String> APPROVAL_ROLE = new TypedField<>(String.class, "approvalRole");
        TypedField<String> APPROVAL_HISTORY = new TypedField<>(String.class, "approvalHistory");
        TypedField<String> DOWNLOAD_USER_NAME = new TypedField<>(String.class, "downloadUserName");
        TypedField<String> DOWNLOAD_STATUS = new TypedField<>(String.class, "downloadStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
