package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * no_po_imprest
 * </p>
 *
 * @author ultraman
 * @since 2022-05-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class NoPoImprest extends Imprest {

  /**
   * 预付子类型
   */
  private String imprestSubType;
  /**
   *  合同ID
   */
  private String contractId;
  /**
   * 合同类型
   */
  private String contractType;
  /**
   * 合同名称
   */
  private String contractName;
  /**
   * 合同签订日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractSignDate;
  /**
   * 合同开始日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractStartDate;
  /**
   * 合同结束日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractEndDate;
  /**
   * 户名
   */
  private String supplierName;
  /**
   * 开户行
   */
  private String supplierBank;
  /**
   * 本次实付金额
   */
  private String payAmount;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("imprest_sub_type", imprestSubType);
      map.put("contract_id", contractId);
      map.put("contract_type", contractType);
      map.put("contract_name", contractName);
      map.put("contract_sign_date", BocpGenUtils.toTimestamp(contractSignDate));
      map.put("contract_start_date", BocpGenUtils.toTimestamp(contractStartDate));
      map.put("contract_end_date", BocpGenUtils.toTimestamp(contractEndDate));
      map.put("supplier_name", supplierName);
      map.put("supplier_bank", supplierBank);
      map.put("pay_amount", payAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static NoPoImprest fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    NoPoImprest entity = new NoPoImprest();

    entity.setParentByOQSMap(map);
    if(map.containsKey("imprest_sub_type")) {
      Object obj = map.get("imprest_sub_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImprestSubType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_id")) {
      Object obj = map.get("contract_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_type")) {
      Object obj = map.get("contract_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_name")) {
      Object obj = map.get("contract_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_sign_date")) {
      Object obj = map.get("contract_sign_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractSignDate(null);
      }
    }
    if(map.containsKey("contract_start_date")) {
      Object obj = map.get("contract_start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractStartDate(null);
      }
    }
    if(map.containsKey("contract_end_date")) {
      Object obj = map.get("contract_end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractEndDate(null);
      }
    }
    if(map.containsKey("supplier_name")) {
      Object obj = map.get("supplier_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplier_bank")) {
      Object obj = map.get("supplier_bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map){
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map){
    super.setByOQSMap(map);
    if(map.containsKey("imprest_sub_type")) {
      Object obj = map.get("imprest_sub_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setImprestSubType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contract_id")) {
      Object obj = map.get("contract_id");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contract_type")) {
      Object obj = map.get("contract_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contract_name")) {
      Object obj = map.get("contract_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contract_sign_date")) {
      Object obj = map.get("contract_sign_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setContractSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setContractSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setContractSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setContractSignDate(null);
      }
   }
    if(map.containsKey("contract_start_date")) {
      Object obj = map.get("contract_start_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setContractStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setContractStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setContractStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setContractStartDate(null);
      }
   }
    if(map.containsKey("contract_end_date")) {
      Object obj = map.get("contract_end_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setContractEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setContractEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setContractEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setContractEndDate(null);
      }
   }
    if(map.containsKey("supplier_name")) {
      Object obj = map.get("supplier_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setSupplierName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("supplier_bank")) {
      Object obj = map.get("supplier_bank");
      if(obj != null) {
        if(obj instanceof String){
            this.setSupplierBank((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setPayAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
