package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * receipt_init_failed_history
 * </p>
 *
 * @author ultraman
 * @since 2022-05-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReceiptInitFailedHistory implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 供应商
   */
  private String seller;
  /**
   * 采购订单
   */
  private String poNumber;
  /**
   * 项目
   */
  private String item;
  /**
   * 工厂
   */
  private String factory;
  /**
   * 存储位置
   */
  private String storageLocation;
  /**
   * 物料
   */
  private String material;
  /**
   * 物料描述
   */
  private String materialDesc;
  /**
   * 批次
   */
  private String batch;
  /**
   * 按订单单位计的数量
   */
  private String orderQuantity;
  /**
   * 订单单位
   */
  private String orderUnit;
  /**
   * 以录入单位表示的数量
   */
  private String enterQuantity;
  /**
   * 条目单位
   */
  private String entryUnit;
  /**
   * 过账日期
   */
  private String postingDate;
  /**
   * 物料凭证
   */
  private String materialDocument;
  /**
   * 物料凭证项目
   */
  private String materialCertificateItem;
  /**
   * 本位币金额
   */
  private String amount;
  /**
   * 主键缺失
   */
  private Boolean isPrimaryKeyAbsent;
  /**
   * 必填项缺失
   */
  private Boolean isRequiredAbsent;
  /**
   * 缺失信息描述
   */
  private String absentMsg;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("seller", seller);
      map.put("poNumber", poNumber);
      map.put("item", item);
      map.put("factory", factory);
      map.put("storageLocation", storageLocation);
      map.put("material", material);
      map.put("materialDesc", materialDesc);
      map.put("batch", batch);
      map.put("orderQuantity", orderQuantity);
      map.put("orderUnit", orderUnit);
      map.put("enterQuantity", enterQuantity);
      map.put("entryUnit", entryUnit);
      map.put("postingDate", postingDate);
      map.put("materialDocument", materialDocument);
      map.put("materialCertificateItem", materialCertificateItem);
      map.put("amount", amount);
      map.put("isPrimaryKeyAbsent", isPrimaryKeyAbsent);
      map.put("isRequiredAbsent", isRequiredAbsent);
      map.put("absentMsg", absentMsg);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ReceiptInitFailedHistory fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReceiptInitFailedHistory entity = new ReceiptInitFailedHistory();

    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFactory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storageLocation")) {
      Object obj = map.get("storageLocation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStorageLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterial((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialDesc")) {
      Object obj = map.get("materialDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch")) {
      Object obj = map.get("batch");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderQuantity")) {
      Object obj = map.get("orderQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderUnit")) {
      Object obj = map.get("orderUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enterQuantity")) {
      Object obj = map.get("enterQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEnterQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryUnit")) {
      Object obj = map.get("entryUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntryUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialDocument")) {
      Object obj = map.get("materialDocument");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialCertificateItem")) {
      Object obj = map.get("materialCertificateItem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialCertificateItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String){
            this.setSeller((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof String){
            this.setItem((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String){
            this.setFactory((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("storageLocation")) {
      Object obj = map.get("storageLocation");
      if(obj != null) {
        if(obj instanceof String){
            this.setStorageLocation((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterial((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialDesc")) {
      Object obj = map.get("materialDesc");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialDesc((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("batch")) {
      Object obj = map.get("batch");
      if(obj != null) {
        if(obj instanceof String){
            this.setBatch((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orderQuantity")) {
      Object obj = map.get("orderQuantity");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderQuantity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orderUnit")) {
      Object obj = map.get("orderUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("enterQuantity")) {
      Object obj = map.get("enterQuantity");
      if(obj != null) {
        if(obj instanceof String){
            this.setEnterQuantity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("entryUnit")) {
      Object obj = map.get("entryUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setEntryUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof String){
            this.setPostingDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialDocument")) {
      Object obj = map.get("materialDocument");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialDocument((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialCertificateItem")) {
      Object obj = map.get("materialCertificateItem");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialCertificateItem((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String) {
            this.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
   }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String) {
            this.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
   }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
            this.setAbsentMsg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
