package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开票通知单业务状态
 * </p>
 *
 * @author ultraman
 * @since 2022-05-27
 */
public enum BusinessStatus {

    _0("0", "待同步"),
    _1("1", "待配单"),
    _2("2", "已配单"),
    _3("3", "部分配单"),
    _4("4", "已冲销"),
    _5("5", "作废"),
    _6("6", "待系统支付"),
    _7("7", "系统已支付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
