package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 预付款标识
 * </p>
 *
 * @author ultraman
 * @since 2022-05-27
 */
public enum PrePaymentIdentification {

    _0("0", "无"),
    _1("1", "小于"),
    _2("2", "等于"),
    _3("3", "大于");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PrePaymentIdentification(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PrePaymentIdentification fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
