package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_detail_relation
 * </p>
 *
 * @author ultraman
 * @since 2022-05-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceDetailRelation implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票ID
   */
  private String invoiceId;
  /**
   * 预制发票id
   */
  private String preInvoiceId;
  /**
   * 业务单号
   */
  private String salesbillNo;
  /**
   * 业务单明细号
   */
  private String salesbillItemNo;
  /**
   * 预制发票明细id
   */
  private String preInvoiceItemId;
  /**
   * 业务单明细id
   */
  private String salesbillItemId;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 货物及服务代码
   */
  private String cargoCode;
  /**
   * 货物及服务名称
   */
  private String cargoName;
  /**
   * 商品代码
   */
  private String itemCode;
  /**
   * 商品名称
   */
  private String itemName;
  /**
   * 明细规格型号
   */
  private String itemSpec;
  /**
   * 数量单位
   */
  private String quantityUnit;
  /**
   * 数量
   */
  private String quantity;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 不含税单价
   */
  private String unitPrice;
  /**
   * 不含税金额
   */
  private String amountWithoutTax;
  /**
   * 含税金额
   */
  private String taxAmount;
  /**
   * 含税金额
   */
  private String amountWithTax;
  /**
   * 税编版本号
   */
  private String goodsNoVer;
  /**
   * 税收分类编码
   */
  private String goodsTaxNo;
  /**
   * 免税标志
   */
  private String taxPre;
  /**
   * 享受税收优惠政策内容
   */
  private String taxPreCon;
  /**
   * 零税率标志
   */
  private String zeroTax;
  /**
   * 折扣行标志 0-默认 1-有折扣
   */
  private String discountFlag;
  /**
   * 价格方式
   */
  private String priceMethod;
  /**
   * 折扣金额
   */
  private String deduction;
  /**
   * 打印标志
   */
  private String printContentFlag;
  /**
   * 发票明细id
   */
  private String invoiceItemId;
  /**
   * 开票通知单号
   */
  private String invoiceNoticeNo;
  /**
   * 开票通知单明细id
   */
  private String invoiceNoticeItemId;
  /**
   * 开票通知单明细号
   */
  private String invoiceNoticeItemNo;
  /**
   * 采购单号
   */
  private String purchaseOrderNo;
  /**
   * 采购单明细id
   */
  private String purchaseOrderItemId;
  /**
   * 采购单明细号
   */
  private String purchaseOrderItemNo;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceId", invoiceId);
      map.put("preInvoiceId", preInvoiceId);
      map.put("salesbillNo", salesbillNo);
      map.put("salesbillItemNo", salesbillItemNo);
      map.put("preInvoiceItemId", preInvoiceItemId);
      map.put("salesbillItemId", salesbillItemId);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("cargoCode", cargoCode);
      map.put("cargoName", cargoName);
      map.put("itemCode", itemCode);
      map.put("itemName", itemName);
      map.put("itemSpec", itemSpec);
      map.put("quantityUnit", quantityUnit);
      map.put("quantity", quantity);
      map.put("taxRate", taxRate);
      map.put("unitPrice", unitPrice);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("goodsNoVer", goodsNoVer);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("taxPre", taxPre);
      map.put("taxPreCon", taxPreCon);
      map.put("zeroTax", zeroTax);
      map.put("discountFlag", discountFlag);
      map.put("priceMethod", priceMethod);
      map.put("deduction", deduction);
      map.put("printContentFlag", printContentFlag);
      map.put("invoiceItemId", invoiceItemId);
      map.put("invoiceNoticeNo", invoiceNoticeNo);
      map.put("invoiceNoticeItemId", invoiceNoticeItemId);
      map.put("invoiceNoticeItemNo", invoiceNoticeItemNo);
      map.put("purchaseOrderNo", purchaseOrderNo);
      map.put("purchaseOrderItemId", purchaseOrderItemId);
      map.put("purchaseOrderItemNo", purchaseOrderItemNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static InvoiceDetailRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceDetailRelation entity = new InvoiceDetailRelation();

    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preInvoiceItemId")) {
      Object obj = map.get("preInvoiceItemId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreInvoiceItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillItemId")) {
      Object obj = map.get("salesbillItemId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargoCode")) {
      Object obj = map.get("cargoCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCargoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsNoVer")) {
      Object obj = map.get("goodsNoVer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsNoVer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountFlag")) {
      Object obj = map.get("discountFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeduction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrintContentFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceItemId")) {
      Object obj = map.get("invoiceItemId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNo")) {
      Object obj = map.get("invoiceNoticeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeItemId")) {
      Object obj = map.get("invoiceNoticeItemId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeItemNo")) {
      Object obj = map.get("invoiceNoticeItemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrderNo")) {
      Object obj = map.get("purchaseOrderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrderItemId")) {
      Object obj = map.get("purchaseOrderItemId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrderItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrderItemNo")) {
      Object obj = map.get("purchaseOrderItemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrderItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreInvoiceId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesbillNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesbillItemNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("preInvoiceItemId")) {
      Object obj = map.get("preInvoiceItemId");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreInvoiceItemId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("salesbillItemId")) {
      Object obj = map.get("salesbillItemId");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesbillItemId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cargoCode")) {
      Object obj = map.get("cargoCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCargoCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCargoName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemSpec((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxRate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof String){
            this.setUnitPrice((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmountWithoutTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmountWithTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("goodsNoVer")) {
      Object obj = map.get("goodsNoVer");
      if(obj != null) {
        if(obj instanceof String){
            this.setGoodsNoVer((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setGoodsTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxPre((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxPreCon((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setZeroTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discountFlag")) {
      Object obj = map.get("discountFlag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDiscountFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
            this.setPriceMethod((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeduction((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrintContentFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceItemId")) {
      Object obj = map.get("invoiceItemId");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceItemId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeNo")) {
      Object obj = map.get("invoiceNoticeNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNoticeNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeItemId")) {
      Object obj = map.get("invoiceNoticeItemId");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNoticeItemId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeItemNo")) {
      Object obj = map.get("invoiceNoticeItemNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNoticeItemNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseOrderNo")) {
      Object obj = map.get("purchaseOrderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseOrderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseOrderItemId")) {
      Object obj = map.get("purchaseOrderItemId");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseOrderItemId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseOrderItemNo")) {
      Object obj = map.get("purchaseOrderItemNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseOrderItemNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
