package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * purchase_order_item
 * </p>
 *
 * @author ultraman
 * @since 2022-05-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderItem implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 采购单号
   */
  private String poNumber;
  /**
   * 采购单行号
   */
  private Long item;
  /**
   * 物料号
   */
  private String materialServices;
  /**
   * WBS
   */
  private String wbs;
  /**
   * 物料名称
   */
  private String materialServicesName;
  /**
   * 币种
   */
  private String currency;
  /**
   * 梯号
   */
  private String ladderNo;
  /**
   * 合同号
   */
  private String contractID;
  /**
   * 梯台状态Id
   */
  private String ladderStatusID;
  /**
   * 梯台状态
   */
  private String ladderStatus;
  /**
   * 税码
   */
  private String vatCode;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 物料组
   */
  private String materialServicesTeam;
  /**
   * 成本中心
   */
  private String costCenter;
  /**
   * 利润中心
   */
  private String profitsCenter;
  /**
   * 总账科目
   */
  private String generalLedgerAccount;
  /**
   * View id
   */
  private String viewId;
  /**
   * 已收货数量
   */
  private BigDecimal receivedCount;
  /**
   * 审批状态
   */
  private String releaseStatus;
  /**
   * PM节点
   */
  private String pmNode;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 单位
   */
  private String quantityUnit;
  /**
   * 数量
   */
  private BigDecimal quantity;
  /**
   * 缺失信息描述
   */
  private String absentMsg;
  /**
   * 删除标记
   */
  private Boolean isDelete;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 单价
   */
  private BigDecimal unitPrice;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 订单状态
   */
  private String orderStatus;
  /**
   * 发布状态
   */
  private String postStatus;

  /**
   * 对一关联关系 关联对象 purchaseOrder
   */
  private Long purchaseOrderItemRelationId;
  /**
   * 对一关联关系 关联对象 wbs
   */
  private Long purchaseOrderItemAndWbsRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("item", item);
      map.put("materialServices", materialServices);
      map.put("wbs", wbs);
      map.put("materialServicesName", materialServicesName);
      map.put("currency", currency);
      map.put("ladderNo", ladderNo);
      map.put("contractID", contractID);
      map.put("ladderStatusID", ladderStatusID);
      map.put("ladderStatus", ladderStatus);
      map.put("vatCode", vatCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("materialServicesTeam", materialServicesTeam);
      map.put("costCenter", costCenter);
      map.put("profitsCenter", profitsCenter);
      map.put("generalLedgerAccount", generalLedgerAccount);
      map.put("viewId", viewId);
      map.put("receivedCount", receivedCount);
      map.put("releaseStatus", releaseStatus);
      map.put("pmNode", pmNode);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("quantityUnit", quantityUnit);
      map.put("quantity", quantity);
      map.put("absentMsg", absentMsg);
      map.put("isDelete", isDelete);
      map.put("taxRate", taxRate);
      map.put("unitPrice", unitPrice);
      map.put("amountWithTax", amountWithTax);
      map.put("orderStatus", orderStatus);
      map.put("postStatus", postStatus);

      map.put("purchaseOrderItemRelation.id", purchaseOrderItemRelationId);
      map.put("purchaseOrderItemAndWbsRelation.id", purchaseOrderItemAndWbsRelationId);
      return map;
  }

  public static PurchaseOrderItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderItem entity = new PurchaseOrderItem();

    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusID")) {
      Object obj = map.get("ladderStatusID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatusID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatus")) {
      Object obj = map.get("ladderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setViewId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivedCount")) {
      Object obj = map.get("receivedCount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivedCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivedCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivedCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReceivedCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivedCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("releaseStatus")) {
      Object obj = map.get("releaseStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReleaseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPmNode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDelete((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostStatus((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("purchaseOrderItemRelation.id")) {
       Object obj = map.get("purchaseOrderItemRelation.id");
       if(obj instanceof Long) {
         entity.setPurchaseOrderItemRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setPurchaseOrderItemRelationId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("purchaseOrderItemAndWbsRelation.id")) {
       Object obj = map.get("purchaseOrderItemAndWbsRelation.id");
       if(obj instanceof Long) {
         entity.setPurchaseOrderItemAndWbsRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setPurchaseOrderItemAndWbsRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setItem((Long)obj);
        } else if(obj instanceof String) {
            this.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServices((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
            this.setWbs((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServicesName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrency((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderStatusID")) {
      Object obj = map.get("ladderStatusID");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderStatusID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderStatus")) {
      Object obj = map.get("ladderStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setVatCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String){
            this.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
            this.setCostCenter((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String){
            this.setProfitsCenter((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String){
            this.setViewId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receivedCount")) {
      Object obj = map.get("receivedCount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivedCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivedCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivedCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setReceivedCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivedCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("releaseStatus")) {
      Object obj = map.get("releaseStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setReleaseStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String){
            this.setPmNode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
            this.setAbsentMsg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsDelete((Boolean)obj);
        } else if(obj instanceof String) {
            this.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
   }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setPostStatus((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("purchaseOrderItemRelation.id")) {
    Object obj = map.get("purchaseOrderItemRelation.id");
    if(obj instanceof Long) {
        this.setPurchaseOrderItemRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setPurchaseOrderItemRelationId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("purchaseOrderItemAndWbsRelation.id")) {
    Object obj = map.get("purchaseOrderItemAndWbsRelation.id");
    if(obj instanceof Long) {
        this.setPurchaseOrderItemAndWbsRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setPurchaseOrderItemAndWbsRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
