package com.xforceplus.ultraman.app.jctke.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-06-14
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    SE("se", "增值税电子专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    CT("ct", "增值税普通发票（通行费）"),
    JU("ju", "增值税普通发票（卷票）"),
    V("v", "机动车统一销售发票"),
    OTHER("other", "其他发票"),
    PAYMENT("payment", "海关缴款书"),
    GM("gm", "通用手工发票"),
    LER("ler", "诉讼费收据"),
    CSF("csf", "罚没财务专用发票"),
    TP("tp", "税收缴款书"),
    TPC("tpc", "税收完税证明"),
    FR("fr", "非税收入票据"),
    SPCIV("spciv", "海关进口增值税缴款书"),
    SPCIT("spcit", "海关进口关税缴款书"),
    X("x", "形式发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "se":
                return SE;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ct":
                return CT;
            case "ju":
                return JU;
            case "v":
                return V;
            case "other":
                return OTHER;
            case "payment":
                return PAYMENT;
            case "gm":
                return GM;
            case "ler":
                return LER;
            case "csf":
                return CSF;
            case "tp":
                return TP;
            case "tpc":
                return TPC;
            case "fr":
                return FR;
            case "spciv":
                return SPCIV;
            case "spcit":
                return SPCIT;
            case "x":
                return X;
            default:
                return null;
        }
    }
}
