package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * payment_manage
 * </p>
 *
 * @author ultraman
 * @since 2022-06-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PaymentManage implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 申请ID
   */
  private String applyId;
  /**
   * 申请人
   */
  private String applyUserName;
  /**
   * 付款类型
   */
  private String paymentType;
  /**
   * 业务类型
   */
  private String businessType;
  /**
   * 预付款类型
   */
  private String prepaymentType;
  /**
   * 保证金类型
   */
  private String bondType;
  /**
   * 付款对象ID
   */
  private String paymentObjectId;
  /**
   * 付款对象
   */
  private String paymentObject;
  /**
   * 本次申请支付金额
   */
  private BigDecimal applyPaymentAmount;
  /**
   * 本次申请实付金额
   */
  private BigDecimal applyPaidAmount;
  /**
   * 订单总金额
   */
  private BigDecimal orderAmount;
  /**
   * 发票总金额
   */
  private BigDecimal invoiceAmount;
  /**
   * 预付金额
   */
  private BigDecimal prepaymentAmount;
  /**
   * 收款累计
   */
  private BigDecimal collectionAccumulation;
  /**
   * 付款累计
   */
  private BigDecimal paymentAccumulation;
  /**
   * 预付款请求号
   */
  private String prepaymentRequestNo;
  /**
   * 预付款支付凭证
   */
  private String prepaymentPaymentVoucher;
  /**
   * 预付款核销凭证
   */
  private String prepaymentWriteVoucher;
  /**
   * 应付款凭证
   */
  private String paymentVoucher;
  /**
   * 应付款支付凭证
   */
  private String paymentPaymentVoucher;
  /**
   * 应付款清账凭证
   */
  private String paymentClearingVoucher;
  /**
   * 当前状态
   */
  private String currentStatus;
  /**
   * 异常信息
   */
  private String errorInfo;
  /**
   * 利润中心
   */
  private String profitCenter;
  /**
   * 成本中心
   */
  private String costCenter;
  /**
   * 付款人类型
   */
  private String paymentUserType;
  /**
   * 付款到期日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDueDate;
  /**
   * 付款银行类型
   */
  private String paymentBankType;
  /**
   * 收款银行
   */
  private String collectionBank;
  /**
   * 收款账户
   */
  private String collectionAccount;
  /**
   * 收款户名
   */
  private String collectionName;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 合同名称
   */
  private String contractName;
  /**
   * 合同金额
   */
  private BigDecimal contractAmount;
  /**
   * 合同类型
   */
  private String contractType;
  /**
   * 起始日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;
  /**
   * 截止日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;
  /**
   * 附件
   */
  private String file;
  /**
   * 文本
   */
  private String text;
  /**
   * 付款备注
   */
  private String paymentRemark;
  /**
   * 审批历史
   */
  private String approvalHistory;
  /**
   * 下载者
   */
  private String downloadUserName;
  /**
   * 下载状态
   */
  private String downloadStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 合同签订日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractSignDate;
  /**
   * 附件地址
   */
  private String fileUrl;
  /**
   * 附件名称
   */
  private String fileName;
  /**
   * 开票通知单号
   */
  private String invoiceNoticeNOs;
  /**
   * 当前审批角色
   */
  private String approvalRole;
  /**
   * 采购订单号
   */
  private String poNos;
  /**
   * 执行分公司id
   */
  private String companyId;
  /**
   * 执行分公司
   */
  private String companyName;
  /**
   * 发票分公司id
   */
  private String purchaserId;
  /**
   * 发票分公司
   */
  private String purchaserName;
  /**
   * 驳回原因
   */
  private String approvalBody;
  /**
   * agentPaymentTerm
   */
  private String agentPaymentTerm;
  /**
   * 备用金类型
   */
  private String pettyCashType;
  /**
   * 采购组织
   */
  private String purchasingOrg;
  /**
   * 采购组
   */
  private String procurementGroup;
  /**
   * 冻结付款
   */
  private Boolean freezePayment;
  /**
   * 应付款商票凭证
   */
  private String commercialPaymentVoucher;
  /**
   * 换票类型
   */
  private String alterInvoiceIndicator;
  /**
   * 原付款单号
   */
  private String previousApplyId;
  /**
   * 新付款单号
   */
  private String nextApplyId;
  /**
   * 实际付款日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;

  /**
   * 对一关联关系 关联对象 invoice
   */
  private Long invoiceAndPaymentRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyId", applyId);
      map.put("applyUserName", applyUserName);
      map.put("paymentType", paymentType);
      map.put("businessType", businessType);
      map.put("prepaymentType", prepaymentType);
      map.put("bondType", bondType);
      map.put("paymentObjectId", paymentObjectId);
      map.put("paymentObject", paymentObject);
      map.put("applyPaymentAmount", applyPaymentAmount);
      map.put("applyPaidAmount", applyPaidAmount);
      map.put("orderAmount", orderAmount);
      map.put("invoiceAmount", invoiceAmount);
      map.put("prepaymentAmount", prepaymentAmount);
      map.put("collectionAccumulation", collectionAccumulation);
      map.put("paymentAccumulation", paymentAccumulation);
      map.put("prepaymentRequestNo", prepaymentRequestNo);
      map.put("prepaymentPaymentVoucher", prepaymentPaymentVoucher);
      map.put("prepaymentWriteVoucher", prepaymentWriteVoucher);
      map.put("paymentVoucher", paymentVoucher);
      map.put("paymentPaymentVoucher", paymentPaymentVoucher);
      map.put("paymentClearingVoucher", paymentClearingVoucher);
      map.put("currentStatus", currentStatus);
      map.put("errorInfo", errorInfo);
      map.put("profitCenter", profitCenter);
      map.put("costCenter", costCenter);
      map.put("paymentUserType", paymentUserType);
      map.put("paymentDueDate", BocpGenUtils.toTimestamp(paymentDueDate));
      map.put("paymentBankType", paymentBankType);
      map.put("collectionBank", collectionBank);
      map.put("collectionAccount", collectionAccount);
      map.put("collectionName", collectionName);
      map.put("contractNo", contractNo);
      map.put("contractName", contractName);
      map.put("contractAmount", contractAmount);
      map.put("contractType", contractType);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("endDate", BocpGenUtils.toTimestamp(endDate));
      map.put("file", file);
      map.put("text", text);
      map.put("paymentRemark", paymentRemark);
      map.put("approvalHistory", approvalHistory);
      map.put("downloadUserName", downloadUserName);
      map.put("downloadStatus", downloadStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("contractSignDate", BocpGenUtils.toTimestamp(contractSignDate));
      map.put("fileUrl", fileUrl);
      map.put("fileName", fileName);
      map.put("invoiceNoticeNOs", invoiceNoticeNOs);
      map.put("approvalRole", approvalRole);
      map.put("poNos", poNos);
      map.put("companyId", companyId);
      map.put("companyName", companyName);
      map.put("purchaserId", purchaserId);
      map.put("purchaserName", purchaserName);
      map.put("approvalBody", approvalBody);
      map.put("agentPaymentTerm", agentPaymentTerm);
      map.put("pettyCashType", pettyCashType);
      map.put("purchasingOrg", purchasingOrg);
      map.put("procurementGroup", procurementGroup);
      map.put("freezePayment", freezePayment);
      map.put("commercialPaymentVoucher", commercialPaymentVoucher);
      map.put("alterInvoiceIndicator", alterInvoiceIndicator);
      map.put("previousApplyId", previousApplyId);
      map.put("nextApplyId", nextApplyId);
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));

      map.put("invoiceAndPaymentRelation.id", invoiceAndPaymentRelationId);
      return map;
  }

  public static PaymentManage fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PaymentManage entity = new PaymentManage();

    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBondType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObjectId")) {
      Object obj = map.get("paymentObjectId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentObjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObject")) {
      Object obj = map.get("paymentObject");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentObject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPaymentAmount")) {
      Object obj = map.get("applyPaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setApplyPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setApplyPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setApplyPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setApplyPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("applyPaidAmount")) {
      Object obj = map.get("applyPaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setApplyPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setApplyPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setApplyPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setApplyPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentAmount")) {
      Object obj = map.get("prepaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPrepaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccumulation")) {
      Object obj = map.get("collectionAccumulation");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCollectionAccumulation((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCollectionAccumulation(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCollectionAccumulation(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCollectionAccumulation(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCollectionAccumulation(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentAccumulation")) {
      Object obj = map.get("paymentAccumulation");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAccumulation((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAccumulation(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAccumulation(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentAccumulation(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAccumulation(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentRequestNo")) {
      Object obj = map.get("prepaymentRequestNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentRequestNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentPaymentVoucher")) {
      Object obj = map.get("prepaymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentWriteVoucher")) {
      Object obj = map.get("prepaymentWriteVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentWriteVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucher")) {
      Object obj = map.get("paymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPaymentVoucher")) {
      Object obj = map.get("paymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentClearingVoucher")) {
      Object obj = map.get("paymentClearingVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentClearingVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentStatus")) {
      Object obj = map.get("currentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUserType")) {
      Object obj = map.get("paymentUserType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUserType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDueDate")) {
      Object obj = map.get("paymentDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDueDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDueDate(null);
      }
    }
    if(map.containsKey("paymentBankType")) {
      Object obj = map.get("paymentBankType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentBankType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBank")) {
      Object obj = map.get("collectionBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionName")) {
      Object obj = map.get("collectionName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmount")) {
      Object obj = map.get("contractAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("file")) {
      Object obj = map.get("file");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRemark")) {
      Object obj = map.get("paymentRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalHistory")) {
      Object obj = map.get("approvalHistory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalHistory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadUserName")) {
      Object obj = map.get("downloadUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadStatus")) {
      Object obj = map.get("downloadStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractSignDate")) {
      Object obj = map.get("contractSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractSignDate(null);
      }
    }
    if(map.containsKey("fileUrl")) {
      Object obj = map.get("fileUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNOs")) {
      Object obj = map.get("invoiceNoticeNOs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNOs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalRole")) {
      Object obj = map.get("approvalRole");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNos")) {
      Object obj = map.get("poNos");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalBody")) {
      Object obj = map.get("approvalBody");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentPaymentTerm")) {
      Object obj = map.get("agentPaymentTerm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentPaymentTerm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pettyCashType")) {
      Object obj = map.get("pettyCashType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPettyCashType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementGroup")) {
      Object obj = map.get("procurementGroup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezePayment")) {
      Object obj = map.get("freezePayment");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFreezePayment((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setFreezePayment(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("commercialPaymentVoucher")) {
      Object obj = map.get("commercialPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommercialPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alterInvoiceIndicator")) {
      Object obj = map.get("alterInvoiceIndicator");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAlterInvoiceIndicator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousApplyId")) {
      Object obj = map.get("previousApplyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreviousApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nextApplyId")) {
      Object obj = map.get("nextApplyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNextApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }

    if(map.containsKey("invoiceAndPaymentRelation.id")) {
       Object obj = map.get("invoiceAndPaymentRelation.id");
       if(obj instanceof Long) {
         entity.setInvoiceAndPaymentRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setInvoiceAndPaymentRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrepaymentType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBondType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentObjectId")) {
      Object obj = map.get("paymentObjectId");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentObjectId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentObject")) {
      Object obj = map.get("paymentObject");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentObject((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyPaymentAmount")) {
      Object obj = map.get("applyPaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setApplyPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setApplyPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setApplyPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setApplyPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setApplyPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("applyPaidAmount")) {
      Object obj = map.get("applyPaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setApplyPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setApplyPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setApplyPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setApplyPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setApplyPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("prepaymentAmount")) {
      Object obj = map.get("prepaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrepaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrepaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrepaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPrepaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrepaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("collectionAccumulation")) {
      Object obj = map.get("collectionAccumulation");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCollectionAccumulation((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCollectionAccumulation(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCollectionAccumulation(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setCollectionAccumulation(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCollectionAccumulation(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("paymentAccumulation")) {
      Object obj = map.get("paymentAccumulation");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPaymentAccumulation((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPaymentAccumulation(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPaymentAccumulation(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPaymentAccumulation(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPaymentAccumulation(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("prepaymentRequestNo")) {
      Object obj = map.get("prepaymentRequestNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrepaymentRequestNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("prepaymentPaymentVoucher")) {
      Object obj = map.get("prepaymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrepaymentPaymentVoucher((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("prepaymentWriteVoucher")) {
      Object obj = map.get("prepaymentWriteVoucher");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrepaymentWriteVoucher((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentVoucher")) {
      Object obj = map.get("paymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentVoucher((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentPaymentVoucher")) {
      Object obj = map.get("paymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentPaymentVoucher((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentClearingVoucher")) {
      Object obj = map.get("paymentClearingVoucher");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentClearingVoucher((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currentStatus")) {
      Object obj = map.get("currentStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrentStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String){
            this.setErrorInfo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
            this.setProfitCenter((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
            this.setCostCenter((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentUserType")) {
      Object obj = map.get("paymentUserType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentUserType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentDueDate")) {
      Object obj = map.get("paymentDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaymentDueDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setPaymentDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaymentDueDate(null);
      }
   }
    if(map.containsKey("paymentBankType")) {
      Object obj = map.get("paymentBankType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentBankType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("collectionBank")) {
      Object obj = map.get("collectionBank");
      if(obj != null) {
        if(obj instanceof String){
            this.setCollectionBank((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setCollectionAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("collectionName")) {
      Object obj = map.get("collectionName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCollectionName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractAmount")) {
      Object obj = map.get("contractAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setContractAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setContractAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setContractAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setContractAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setContractAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartDate(null);
      }
   }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndDate(null);
      }
   }
    if(map.containsKey("file")) {
      Object obj = map.get("file");
      if(obj != null) {
        if(obj instanceof String){
            this.setFile((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String){
            this.setText((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentRemark")) {
      Object obj = map.get("paymentRemark");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("approvalHistory")) {
      Object obj = map.get("approvalHistory");
      if(obj != null) {
        if(obj instanceof String){
            this.setApprovalHistory((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("downloadUserName")) {
      Object obj = map.get("downloadUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setDownloadUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("downloadStatus")) {
      Object obj = map.get("downloadStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setDownloadStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractSignDate")) {
      Object obj = map.get("contractSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setContractSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setContractSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setContractSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setContractSignDate(null);
      }
   }
    if(map.containsKey("fileUrl")) {
      Object obj = map.get("fileUrl");
      if(obj != null) {
        if(obj instanceof String){
            this.setFileUrl((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String){
            this.setFileName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeNOs")) {
      Object obj = map.get("invoiceNoticeNOs");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNoticeNOs((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("approvalRole")) {
      Object obj = map.get("approvalRole");
      if(obj != null) {
        if(obj instanceof String){
            this.setApprovalRole((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("poNos")) {
      Object obj = map.get("poNos");
      if(obj != null) {
        if(obj instanceof String){
            this.setPoNos((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String){
            this.setCompanyId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("approvalBody")) {
      Object obj = map.get("approvalBody");
      if(obj != null) {
        if(obj instanceof String){
            this.setApprovalBody((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("agentPaymentTerm")) {
      Object obj = map.get("agentPaymentTerm");
      if(obj != null) {
        if(obj instanceof String){
            this.setAgentPaymentTerm((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pettyCashType")) {
      Object obj = map.get("pettyCashType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPettyCashType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchasingOrg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementGroup")) {
      Object obj = map.get("procurementGroup");
      if(obj != null) {
        if(obj instanceof String){
            this.setProcurementGroup((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("freezePayment")) {
      Object obj = map.get("freezePayment");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setFreezePayment((Boolean)obj);
        } else if(obj instanceof String) {
            this.setFreezePayment(Boolean.valueOf((String)obj));
        }
      } else{
      }
   }
    if(map.containsKey("commercialPaymentVoucher")) {
      Object obj = map.get("commercialPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
            this.setCommercialPaymentVoucher((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("alterInvoiceIndicator")) {
      Object obj = map.get("alterInvoiceIndicator");
      if(obj != null) {
        if(obj instanceof String){
            this.setAlterInvoiceIndicator((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("previousApplyId")) {
      Object obj = map.get("previousApplyId");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreviousApplyId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("nextApplyId")) {
      Object obj = map.get("nextApplyId");
      if(obj != null) {
        if(obj instanceof String){
            this.setNextApplyId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaymentDate(null);
      }
   }

  if(map.containsKey("invoiceAndPaymentRelation.id")) {
    Object obj = map.get("invoiceAndPaymentRelation.id");
    if(obj instanceof Long) {
        this.setInvoiceAndPaymentRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setInvoiceAndPaymentRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
