package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_notice_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-06-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceNoticeBill implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 业务单类型
   */
  private String businessType;
  /**
   * 分公司ID
   */
  private String buyerID;
  /**
   * 不含税金额
   */
  private BigDecimal totalAmount;
  /**
   * 供应商名
   */
  private String sellerName;
  /**
   * 执行分公司
   */
  private String buyerName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 前置单据号
   */
  private String preNo;
  /**
   * 分期数
   */
  private Long installmentNum;
  /**
   * 含税金额
   */
  private BigDecimal totalAmountWithTax;
  /**
   * 发票备注
   */
  private String invoiceRemark;
  /**
   * 计价方式 （0-不含税价 1-含税价）
   */
  private String priceMethod;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * WBS
   */
  private String wbs;
  /**
   * 梯号
   */
  private String ladderNo;
  /**
   * 币种
   */
  private String currency;
  /**
   * 节点
   */
  private String node;
  /**
   * 已发货数量
   */
  private BigDecimal hippedQuantity;
  /**
   * 开票通知单号
   */
  private String invoiceNoticeNO;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 生成结算单状态
   */
  private String status;
  /**
   * 供应商号
   */
  private String sellerNo;
  /**
   * 采购组
   */
  private String purchasingTeam;
  /**
   * 采购组织
   */
  private String purchasingOrg;
  /**
   * 发票分公司
   */
  private String buyerInvoiceTitle;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 开票通知单类型
   */
  private String type;
  /**
   * 业务状态
   */
  private String allocationOrderStatus;
  /**
   * 备注
   */
  private String remark;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 销方银行账号
   */
  private String sellerBankNo;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方联系电话
   */
  private String sellerTelephone;
  /**
   * 接收邮箱
   */
  private String receiveEmail;
  /**
   * 接收电话
   */
  private String receiveTelephone;
  /**
   * 购方地址
   */
  private String purchaseAddress;
  /**
   * 购方电话
   */
  private String purchaseTelephone;
  /**
   * 购方银行账号
   */
  private String purchaseBankNo;
  /**
   * 购方银行名称
   */
  private String purchaseBankName;
  /**
   * 收款人
   */
  private String cashierName;
  /**
   * 复核人
   */
  private String checkerName;
  /**
   * 开票人
   */
  private String invoicerName;
  /**
   * 红字信息表编号
   */
  private String redNotificationNo;
  /**
   * 利润中心
   */
  private String profitCenter;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 采购单含税金额
   */
  private BigDecimal poTotalAmountWithTax;
  /**
   * 推荐发票id
   */
  private String recommendationInvoiceId;
  /**
   * 推荐发票号码
   */
  private String recommendationInvoiceNo;
  /**
   * 订单类型
   */
  private String orderType;
  /**
   * 逆向付款单号
   */
  private String negativePaymentNo;
  /**
   * 换票类型
   */
  private String changeTicketType;
  /**
   * 已配单金额
   */
  private BigDecimal distributeOrderInvoiceAmount;
  /**
   * 已支付金额
   */
  private BigDecimal paidAmount;
  /**
   * 已生成结算单金额
   */
  private BigDecimal businessAmount;

  /**
   * 对一关联关系 关联对象 purchaseOrder
   */
  private Long purchaseOrderAndinvoiceNoticRelationeBillId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceType", invoiceType);
      map.put("businessType", businessType);
      map.put("buyerID", buyerID);
      map.put("totalAmount", totalAmount);
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("preNo", preNo);
      map.put("installmentNum", installmentNum);
      map.put("totalAmountWithTax", totalAmountWithTax);
      map.put("invoiceRemark", invoiceRemark);
      map.put("priceMethod", priceMethod);
      map.put("taxAmount", taxAmount);
      map.put("wbs", wbs);
      map.put("ladderNo", ladderNo);
      map.put("currency", currency);
      map.put("node", node);
      map.put("hippedQuantity", hippedQuantity);
      map.put("invoiceNoticeNO", invoiceNoticeNO);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("status", status);
      map.put("sellerNo", sellerNo);
      map.put("purchasingTeam", purchasingTeam);
      map.put("purchasingOrg", purchasingOrg);
      map.put("buyerInvoiceTitle", buyerInvoiceTitle);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserNo", purchaserNo);
      map.put("type", type);
      map.put("allocationOrderStatus", allocationOrderStatus);
      map.put("remark", remark);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("sellerBankNo", sellerBankNo);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTelephone", sellerTelephone);
      map.put("receiveEmail", receiveEmail);
      map.put("receiveTelephone", receiveTelephone);
      map.put("purchaseAddress", purchaseAddress);
      map.put("purchaseTelephone", purchaseTelephone);
      map.put("purchaseBankNo", purchaseBankNo);
      map.put("purchaseBankName", purchaseBankName);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("redNotificationNo", redNotificationNo);
      map.put("profitCenter", profitCenter);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("projectName", projectName);
      map.put("poTotalAmountWithTax", poTotalAmountWithTax);
      map.put("recommendationInvoiceId", recommendationInvoiceId);
      map.put("recommendationInvoiceNo", recommendationInvoiceNo);
      map.put("orderType", orderType);
      map.put("negativePaymentNo", negativePaymentNo);
      map.put("changeTicketType", changeTicketType);
      map.put("distributeOrderInvoiceAmount", distributeOrderInvoiceAmount);
      map.put("paidAmount", paidAmount);
      map.put("businessAmount", businessAmount);

      map.put("purchaseOrderAndinvoiceNoticRelationeBill.id", purchaseOrderAndinvoiceNoticRelationeBillId);
      return map;
  }

  public static InvoiceNoticeBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceNoticeBill entity = new InvoiceNoticeBill();

    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preNo")) {
      Object obj = map.get("preNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("installmentNum")) {
      Object obj = map.get("installmentNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInstallmentNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setInstallmentNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInstallmentNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountWithTax")) {
      Object obj = map.get("totalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceRemark")) {
      Object obj = map.get("invoiceRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("node")) {
      Object obj = map.get("node");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hippedQuantity")) {
      Object obj = map.get("hippedQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setHippedQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setHippedQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setHippedQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setHippedQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setHippedQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNO")) {
      Object obj = map.get("invoiceNoticeNO");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allocationOrderStatus")) {
      Object obj = map.get("allocationOrderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAllocationOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveEmail")) {
      Object obj = map.get("receiveEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveTelephone")) {
      Object obj = map.get("receiveTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poTotalAmountWithTax")) {
      Object obj = map.get("poTotalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPoTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPoTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPoTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPoTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPoTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recommendationInvoiceId")) {
      Object obj = map.get("recommendationInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecommendationInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recommendationInvoiceNo")) {
      Object obj = map.get("recommendationInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecommendationInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("negativePaymentNo")) {
      Object obj = map.get("negativePaymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNegativePaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeTicketType")) {
      Object obj = map.get("changeTicketType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChangeTicketType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributeOrderInvoiceAmount")) {
      Object obj = map.get("distributeOrderInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistributeOrderInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistributeOrderInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistributeOrderInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDistributeOrderInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistributeOrderInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("businessAmount")) {
      Object obj = map.get("businessAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBusinessAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBusinessAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBusinessAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBusinessAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    if(map.containsKey("purchaseOrderAndinvoiceNoticRelationeBill.id")) {
       Object obj = map.get("purchaseOrderAndinvoiceNoticRelationeBill.id");
       if(obj instanceof Long) {
         entity.setPurchaseOrderAndinvoiceNoticRelationeBillId((Long)obj);
       } else if(obj instanceof String) {
         entity.setPurchaseOrderAndinvoiceNoticRelationeBillId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerID((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("preNo")) {
      Object obj = map.get("preNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("installmentNum")) {
      Object obj = map.get("installmentNum");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInstallmentNum((Long)obj);
        } else if(obj instanceof String) {
            this.setInstallmentNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInstallmentNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("totalAmountWithTax")) {
      Object obj = map.get("totalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceRemark")) {
      Object obj = map.get("invoiceRemark");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
            this.setPriceMethod((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
            this.setWbs((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setLadderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrency((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("node")) {
      Object obj = map.get("node");
      if(obj != null) {
        if(obj instanceof String){
            this.setNode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hippedQuantity")) {
      Object obj = map.get("hippedQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setHippedQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setHippedQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setHippedQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setHippedQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setHippedQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNoticeNO")) {
      Object obj = map.get("invoiceNoticeNO");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNoticeNO((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchasingTeam((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchasingOrg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
            this.setType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("allocationOrderStatus")) {
      Object obj = map.get("allocationOrderStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setAllocationOrderStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTelephone((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receiveEmail")) {
      Object obj = map.get("receiveEmail");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceiveEmail((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receiveTelephone")) {
      Object obj = map.get("receiveTelephone");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceiveTelephone((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseAddress((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseTelephone((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseBankNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCashierName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoicerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setRedNotificationNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
            this.setProfitCenter((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("poTotalAmountWithTax")) {
      Object obj = map.get("poTotalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPoTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPoTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPoTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPoTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPoTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("recommendationInvoiceId")) {
      Object obj = map.get("recommendationInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
            this.setRecommendationInvoiceId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("recommendationInvoiceNo")) {
      Object obj = map.get("recommendationInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setRecommendationInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("negativePaymentNo")) {
      Object obj = map.get("negativePaymentNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setNegativePaymentNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("changeTicketType")) {
      Object obj = map.get("changeTicketType");
      if(obj != null) {
        if(obj instanceof String){
            this.setChangeTicketType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("distributeOrderInvoiceAmount")) {
      Object obj = map.get("distributeOrderInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDistributeOrderInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDistributeOrderInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDistributeOrderInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setDistributeOrderInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDistributeOrderInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("businessAmount")) {
      Object obj = map.get("businessAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBusinessAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBusinessAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBusinessAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setBusinessAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBusinessAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }

  if(map.containsKey("purchaseOrderAndinvoiceNoticRelationeBill.id")) {
    Object obj = map.get("purchaseOrderAndinvoiceNoticRelationeBill.id");
    if(obj instanceof Long) {
        this.setPurchaseOrderAndinvoiceNoticRelationeBillId((Long)obj);
    } else if(obj instanceof String) {
        this.setPurchaseOrderAndinvoiceNoticRelationeBillId(Long.parseLong((String)obj));
    }
  }
  }

}
